package provide GMEPlot 1.0

# THIS gets and plots any SSIES data along the DMSP orbit track

proc SSIESData { } {
   global gmANS env ExDa \
          SvX SvY SvZ SNi SH SHe SO STi STe \
          QvX QvY QvZ QNi QH QHe QO QTi QTe

   set tE [list $gmANS(eYr) $gmANS(eDy) $gmANS(eMs) 0]
   set oFE [TUtimeConv $gmANS(baseT) $tE 0 gmANS(Base)]
   set gmANS(otS) -1
   set gmANS(otF) -1

   set sN [string range $gmANS(DMSPsat) 5 7]
   set KeY [GetDataKey DMSP $gmANS(DMSPsat) SSIES SSIES ${sN}SSIES] 

   GridParams gI ETIME
   GridParams pgI 2D

# USE this version and structure number

   set Ver 0
   set N 0

# OPEN the data and position to the starting time

   FileOpen $KeY $Ver \
       $gmANS(sY) $gmANS(sD) $gmANS(sH) $gmANS(sM) $gmANS(sS) \
       $gmANS(fY) $gmANS(fD) $gmANS(fH) $gmANS(fM) $gmANS(fS)

   FilePos $KeY $Ver $gmANS(sY) $gmANS(sD) $gmANS(sH) \
       $gmANS(sM) $gmANS(sS) FINE

# GET the UNIT Algorithms 
#
# Vx:  Pidf Sensor 0, Unit 0
# Vy:  Pidf Sensor 1, Unit 0
# Vz:  Pidf Sensor 2, Unit 0
# De:  Pidf Sensor 3, Unit 1
# Ti:  Pidf Sensor 4, Unit 2
# Te:  Pidf Sensor 5, Unit 2
# H:   Pidf Sensor 9, Unit 6
# He:  Pidf Sensor 10, Unit 6
# O:   Pidf Sensor 11, Unit 6

   set U00 [UTILunits $KeY,$Ver 0 0]
   set U10 [UTILunits $KeY,$Ver 0 1]
   set U20 [UTILunits $KeY,$Ver 0 2]
   set U31 [UTILunits $KeY,$Ver 1 3]
   set U42 [UTILunits $KeY,$Ver 2 4]
   set U52 [UTILunits $KeY,$Ver 2 5]
   set U96 [UTILunits $KeY,$Ver 6 9]
   set U106 [UTILunits $KeY,$Ver 6 10]
   set U116 [UTILunits $KeY,$Ver 6 11]

# GET the data

   set More -1
   set J 0 
   set nQ $N,QuaL
   set OK -1.0e10

   while { $More < 0 } {
      set EoF [ReadUDF $KeY $Ver $N 0 0 0 0]
      set vX($J) [ConvertToUnits $KeY $Ver $N $U00 Data SENSOR]
      if { $ExDa($nQ) != 2 } { set qvX($J) $OK } else { set qvX($J) $vX($J) } 
      set EoF [ReadUDF $KeY $Ver $N 1 0 0 0]
      set vY($J) [ConvertToUnits $KeY $Ver $N $U10 Data SENSOR]
      if { $ExDa($nQ) != 2 } { set qvY($J) $OK } else { set qvY($J) $vY($J) } 
      set EoF [ReadUDF $KeY $Ver $N 2 0 0 0]
      set vZ($J) [ConvertToUnits $KeY $Ver $N $U20 Data SENSOR]
      if { $ExDa($nQ) != 2 } { set qvZ($J) $OK } else { set qvZ($J) $vZ($J) } 
      set EoF [ReadUDF $KeY $Ver $N 3 0 0 0]
      set Ni($J)  [ConvertToUnits $KeY $Ver $N $U31 Data SENSOR]
      set H($J) [ConvertToUnits $KeY $Ver $N $U96 Data]
      set He($J) [ConvertToUnits $KeY $Ver $N $U106 Data]
      set O($J) [ConvertToUnits $KeY $Ver $N $U116 Data]
      if { $ExDa($nQ) != 2 } { set qNi($J) $OK } else { set qNi($J) $Ni($J) } 
      if { $ExDa($nQ) != 2 } { set qH($J) $OK } else { set qH($J) $H($J) } 
      if { $ExDa($nQ) != 2 } { set qHe($J) $OK } else { set qHe($J) $He($J) } 
      if { $ExDa($nQ) != 2 } { set qO($J) $OK } else { set qO($J) $O($J) } 
      set EoF [ReadUDF $KeY $Ver $N 4 0 0 0]
      set Ti($J) [ConvertToUnits $KeY $Ver $N $U42 Data SENSOR]
      if { $ExDa($nQ) != 2 } { set qTi($J) $OK } else { set qTi($J) $Ti($J) } 
      set EoF [ReadUDF $KeY $Ver $N 5 0 1 0]
      set Te($J) [ConvertToUnits $KeY $Ver $N $U52 Data SENSOR]
      if { $ExDa($nQ) != 2 } { set qTe($J) $OK } else { set qTe($J) $Te($J) } 

      set yB $ExDa($N,BYR)
      set dB $ExDa($N,BDY)
      set mB $ExDa($N,BMSEC)
      set yE $ExDa($N,EYR)
      set dE $ExDa($N,EDY)
      set mE $ExDa($N,EMSEC)

# INTERVAL spanned by a measurement

      if { $J == 0 } {
         set dT [expr ($mE - $mB)/1000]
         if { $dT < 0 } { set dT [expr $dT +  86400] }
         set MdT [expr $dT / 2.0]
      }

      set curT [list $yB $dB $mB 0]
      if [string match EOF $EoF] { break }
                                                                                
      set tM($J) [expr [TUtimeConv $gmANS(baseT) $curT 0 gmANS(Base)] + $MdT]
      incr J

      set More [TUtimeCmp 0 $yE $dE $mE $gmANS(fY) $gmANS(fD) $gmANS(fMs)]
   }

   set tY(0) 0.0
   set gList [list SvX SvY SvZ SNi SH SHe SO STi STe \
                   QvX QvY QvZ QNi QH QHe QO QTi QTe]
   set vList [list  vX  vY  vZ  Ni  H  He  O  Ti  Te \
                   qvX qvY qvZ qNi qH qHe qO qTi qTe]

   set vL [llength $vList]
   for { set I 0 } { $I < $vL } { incr I } {
      set TmP [lindex $vList $I] ; upvar 0 $TmP V
      set TmP [lindex $gList $I] ; upvar 0 $TmP G
      TUdataGrid $J 1 tM tM $J tY tY V G gNorM gI
      TUgridFill1D G gI X LI -1 0 gNorM
   }
}
