package provide GMEPlot 1.0

# THIS runs the application

proc RunIt { } {
   global gmANS GphInfo env gIH gIM HeImG HegI RgI

   SetUp
   GraphicsUp

# GET the MENA and HENA data

   AssembleMENA
   AssembleHENA

# READ in the EUV simulation data if its needed

   if $gmANS(LoadE) {
      set fName [file join $gmANS(EUVHOME) $gmANS(EUVFILE).sim]  
      set nP [EUVInvRead $fName Xs Ys HeImG HegI AnC]
      set gmANS(HeTIME)   $AnC(TIME)
      set gmANS(HeFORMAT) $AnC(FORMAT)
   }

# BUILD any plasma moment maps.
   
   if {$gmANS(LoadPF) || $gmANS(LoadPS)} { MomMaps }

# BUILD any ratio maps.
                                                                                
   if {$gmANS(LoadRF) || $gmANS(LoadRM) || $gmANS(LoadRH)} { RatioMaps }

# LOAD up the orbit track if needed

   if { $gmANS(TotalLP) > 0 } { 
      UDFInits
      GetOrbitTrack
   }

# LOAD up the SSIES data.

   if $gmANS(LoadSS) { SSIESData }
   

# PRODUCE the plots

   set pN 0
   for { set I 0 } { $I < $gmANS(nR) } { incr I } {
      for { set J 0 } { $J < $gmANS(nC) } { incr J } {
         set DeF r${I}c${J}
         switch -glob -- $gmANS($DeF) {
            EUV  { 
               PlotEUV $pN
               incr pN
            }
            MENA* { 
               set V [string index $gmANS($DeF) 4]
               PlotMAP $pN MENA RECT $V gIM 
               incr pN
            } 
            HENA* { 
               set V [string index $gmANS($DeF) 4]
               PlotMAP $pN HENA POLAR $V gIH 
               incr pN
            } 
            MOM* { 
               set V [string range $gmANS($DeF) 3 4]
	       GridParams gI MOMENTS
               PlotMAP $pN MOM RECT $V gI 
               incr pN
            } 
            RATIO* { 
               set V [string index $gmANS($DeF) 5]
               PlotMAP $pN RATIO RECT $V RgI
               incr pN
            } 
         }
      }
   }

   if [string match YES $gmANS(DmSp)] {
      PlotOrbitTrack
      ParOrbTrackPlot ION 
      ParOrbTrackPlot ELECTRON 
      HeOrbTrackPlot
      MENAOrbTrackPlot
      HENAOrbTrackPlot
      MoMOrbTrackPlot
      RaOrbTrackPlot
      SSIESOrbTrackPlot
      LPOutlines
   }

   if [string match YES $gmANS(XYplot)] { PlotXY }
}
