package provide GMEPlot 1.0

proc RCMoments { } {
   global gmANS GphInfo eV dF PI

   set MinD 1.0e-5

   if { $gmANS(curC) >= 0 } {
      set State [lindex $gmANS(sPS) $gmANS(curC)] 
      if [string match OPEN $State] { return }
   } else { return }


   if { ($gmANS(MHomits) == 2) || ($gmANS(MHomits) == 3) } {
      set ReT [FormXY eV dF oX oY mAV hAV]
      set nP [lindex $ReT 0]
      set nM [lindex $ReT 1]
      set nH [lindex $ReT 2]
      upvar 0 oX iX
      upvar 0 oY iY
   } else {
      set nM [llength $gmANS(AVAILMENA)]
      set nH [llength $gmANS(AVAILHENA)]
      set nP [expr $nM + $nH]
      upvar 0 eV iX
      upvar 0 dF iY
      set mAV $gmANS(AVAILMENA)
      set hAV $gmANS(AVAILHENA)
   }

   if [ string match FULL $gmANS(momRNG)] {
      if [ string match WIDTHS $gmANS(momTYPE)] {
         set nE 0
         set Len [llength mAV]
         for { set I 0 } { $I < $Len } { incr I } {
            set J  [lindex $mAV $I]
            set bE($nE) [lindex $gmANS(MbE) $I]
            set eE($nE) [lindex $gmANS(MeE) $I]
            set fDF($nE) $iY($nE)
            incr nE
         }
         set Len [llength hAV]
         for { set I 0 } { $I < $Len } { incr I } {
            set J  [lindex $hAV $I]
            set bE($nE) [lindex $gmANS(HbE) $J]
            set eE($nE) [lindex $gmANS(HeE) $J]
            set fDF($nE) $iY($nE)
            incr nE
         }
         Moments2D fDF bE eE $nP 1.67e-24 WIDTHS $MinD ReTF
      } else {
         for { set I 0 } { $I < $nP } { incr I } {
            set bC($I) [expr $iX($I) * 1000.0]
            set fDF($I) $iY($I)
         }
         Moments2D fDF bC bC $nP 1.67e-24 CENTERS $MinD ReTF
      }
   } else {
      if [ string match WIDTHS $gmANS(momTYPE)] {
         set nE 0
         for { set I 0 } { $I < $nM } { incr I } {
            set J  [lindex $mAV $I]
            set mbE($I) [lindex $gmANS(MbE) $J]
            set meE($I) [lindex $gmANS(MeE) $J]
            set mDF($I) $iY($nE)
            incr nE
         }
         for { set I 0 } { $I < $nH } { incr I } {
            set J  [lindex $gmANS(AVAILHENA) $I]
            set hbE($I) [lindex $gmANS(HbE) $J]
            set heE($I) [lindex $gmANS(HeE) $J]
            set hDF($I) $iY($nE)
            incr nE
         }
         Moments2D mDF mbE meE $nM 1.67e-24 WIDTHS $MinD ReTM
         Moments2D hDF hbE heE $nH 1.67e-24 WIDTHS $MinD ReTH
      } else {
         set nE 0
         for { set I 0 } { $I < $nM } { incr I } {
            set mbC($I) [expr $iX($nE) * 1000.0]
            set mDF($I) $iY($nE)
            incr nE
         }
         for { set I 0 } { $I < $nH } { incr I } {
            set hbC($I) [expr $iX($nE) * 1000.0]
            set hDF($I) $iY($nE)
            incr nE
         }
         Moments2D mDF mbC mbC $nM 1.67e-24 CENTERS $MinD ReTM
         Moments2D hDF hbC hbC $nH 1.67e-24 CENTERS $MinD ReTH
      }
   }

   set P $gmANS(curC)
   if { $P >= 0 } {
      set W .sWin$gmANS(curSpN)
      for { set I 2 } { $I < 6 } { incr I } {
         $W.info.r${I}c$P delete 0 end
      }
      set C [lindex $gmANS(gCol) $gmANS(curCP)]

      if [ string match FULL $gmANS(momRNG)] {
         $W.info.r2c$P insert end [format "%5.2f  DI" $ReTF(Den)]
         $W.info.r2c$P configure -fg $C
         set ReTF(TmP) [expr $ReTF(TmP) / 1000.0]
         $W.info.r3c$P insert end [format "%5.2f  TI" $ReTF(TmP)]
         $W.info.r3c$P configure -fg $C
      } else {
         $W.info.r2c$P insert end [format "%5.2f DM" $ReTM(Den)]
         $W.info.r2c$P configure -fg $C
         set ReTM(TmP) [expr $ReTM(TmP) / 1000.0]
         $W.info.r3c$P insert end [format "%5.2f TM" $ReTM(TmP)]
         $W.info.r3c$P configure -fg $C
         $W.info.r4c$P insert end [format "%5.2f DH" $ReTH(Den)]
         set ReTH(TmP) [expr $ReTH(TmP) / 1000.0]
         $W.info.r4c$P configure -fg $C
         $W.info.r5c$P insert end [format "%5.2f TH" $ReTH(TmP)]
         $W.info.r5c$P configure -fg $C
      }
   }
}
