package provide GMEPlot 1.0

# THIS puts up an EUV simulation plot

proc PlotXY { } {
   global gmANS GphInfo WinInfo HeImG HegI RgI gIM gIH

# REDUNDANT check to see if we should be here at all

   if { $gmANS(TotalXY) == 0 } { return }

# THIS is the time covered by the plot(s)

   set TimE [format "%d %03d %02d:%02d:%02d TO %d %03d %02d:%02d:%02d" \
       $gmANS(bYr) $gmANS(bDy) $gmANS(bHr) $gmANS(bMn) $gmANS(bSc) \
       $gmANS(eYr) $gmANS(eDy) $gmANS(eHr) $gmANS(eMn) $gmANS(eSc) ]

   set EnD  [expr $gmANS(uE) - $gmANS(uB)]
   set pN 66
   
   set W .sWin$pN
   if { [winfo exists $W] == 0 } {
      toplevel $W

      GUIFrame $W.sp 0 pack|top||both

      set tS 10
      if { $gmANS(TotalXY) == 1 } {
	   set xC 500 ; set yC 500 ; set tS 12 
      } elseif { $gmANS(TotalXY) == 2 } {
	   set xC 700 ; set yC 500 
      } else { set xC 700 ; set yC 700 } 

      GUICanvas $W.sp $xC $yC $xC $yC
      SetScreen 2 $W.sp
      GenWindow sW0 0. 0. 0. 1.0 1.0 0.0 0. 0. 0. 1. 1. 0.

      TextProp $tS 
      set cS [GPHtextLen M XY]
      set cX [lindex $cS 0]
      set cY [lindex $cS 0]

      switch -exact -- $gmANS(TotalXY) {
         1  {  
	    set xB(0) [expr 8.0 * $cX] ; set xT(0) [expr 1. - 2.0 * $cX] 
	    set yB(0) [expr 4.0 * $cY] ; set yT(0) [expr 1. - 4.0 * $cY] 
            set xLb  [expr ($xB(0) + $xT(0))/2.0]
         }
         2  {  
	    set xB(0) [expr 8.0 * $cX]      ; set xT(0) [expr .5 - 2.0 * $cX] 
	    set yB(0) [expr 4.0 * $cY]      ; set yT(0) [expr 1. - 4.0 * $cY] 
	    set xB(1) [expr .5 + 8.0 * $cX] ; set xT(1) [expr 1. - 2.0 * $cX] 
	    set yB(1) [expr 4.0 * $cY]      ; set yT(1) [expr 1. - 4.0 * $cY] 
         }
         3  -  
         4  {  
	    set xB(0) [expr 8.0 * $cX]      ; set xT(0) [expr .5 - 2.0 * $cX] 
	    set yB(0) [expr .5 + 4.0 * $cY] ; set yT(0) [expr 1. - 4.0 * $cY] 
	    set xB(1) [expr .5 + 8.0 * $cX] ; set xT(1) [expr 1. - 2.0 * $cX] 
	    set yB(1) [expr .5 + 4.0 * $cY] ; set yT(1) [expr 1. - 4.0 * $cY] 
	    set xB(2) [expr 8.0 * $cX]      ; set xT(2) [expr .5 - 2.0 * $cX] 
	    set yB(2) [expr 4.0 * $cY]      ; set yT(2) [expr .5 - 4.0 * $cY] 
	    set xB(3) [expr .5 + 8.0 * $cX] ; set xT(3) [expr 1. - 2.0 * $cX] 
	    set yB(3) [expr 4.0 * $cY]      ; set yT(3) [expr .5 - 4.0 * $cY] 
	 }
      }

      set xLb [expr (1. + 6.0 * $cX)/2.0] 
      set yLb [expr 1. - 2.0 * $cY] 
      TexT sW0 $xLb $yLb 0.0 center $TimE $GphInfo(White)

      set wN 40
      for { set I 0 } { $I < 4 } { incr I } { 
          if { ($gmANS(S${I}0) == 0) || ($gmANS(S${I}1) == 0) } {
             continue 
          }

          set xL $gmANS(S${I}0Min) ; set xU $gmANS(S${I}0Max)
          set yL $gmANS(S${I}1Min) ; set yU $gmANS(S${I}1Max)
          set xS $gmANS(S${I}0Sca) ; set yS $gmANS(S${I}1Sca)
          RelWindow $wN sW0 $xB($I) $yB($I) 0. $xT($I) $yT($I) 0. \
                               $xL $yL 0. $xU $yU 0.

          SetAxis $wN PRIMARY HOLD HOLD HOLD HOLD HOLD HOLD $xS $yS HOLD
          SetAxis $wN SECONDARY HOLD HOLD HOLD HOLD HOLD HOLD $xS $yS HOLD

          DefinePlot $wN $wN

          set V(0) $gmANS(S${I}0)
          set V(1) $gmANS(S${I}1)
          set MinI $gmANS(ionLow)
	  set HeFmt $gmANS(HeFORMAT)
	  set MinR -1.0e30
	  set MaxR  1.0e30
          for { set J 0 } { $J < 2 } { incr J } { 
	     if { $J == 0 } { 
	         upvar 0 X vD 
                 set xLab [lindex [LPplotLabels $V($J)] 1]
             } else { 
	         upvar 0 Y vD 
                 set yLab [lindex [LPplotLabels $V($J)] 1]
             }
	     switch -exact -- $V($J) {
                1   { OrbitTrackData CUTXY He HeImG vD $MinI 0.0 $HeFmt HegI }
                30  - 
		31 -
		32 -
		33 {
		   set eS [expr $V($J) - 30]
		   set tG [expr $gIM(4) * $gIM(5)]
		   InOutList TOARRAY GriD gmANS(mG$eS) $tG
		   OrbitTrackData CUTXY MENA GriD vD $MinI 0.0 XY gIM 
		}
                40  - 
		41 -
		42 -
		43 -
		44 -
		45 {
		   set eS [expr $V($J) - 40]
		   set tG [expr $gIH(4) * $gIH(5)]
		   InOutList TOARRAY GriD gmANS(hG$eS) $tG
		   OrbitTrackData CUTXY HENA GriD vD $MinI 0.0 XY gIM 
		}
	        80  { OrbitTrackData SSIESXY Ni vD qD $MinR $MaxR   }
	        81  { OrbitTrackData SSIESXY Te vD qD $MinR $MaxR   }
		82  { OrbitTrackData SSIESXY Ti vD qD $MinR $MaxR   }
		83  { OrbitTrackData SSIESXY vY vD qD $MinR $MaxR   }
		86  { OrbitTrackData SSIESXY vZ vD qD $MinR $MaxR   }
		85  { OrbitTrackData SSIESXY vX vD qD $MinR $MaxR   }
		88  { OrbitTrackData SSIESXY TeCp vD qD $MinR $MaxR }
		89  { OrbitTrackData SSIESXY TiCp vD qD $MinR $MaxR }
		90  { OrbitTrackData SSIESXY H vD qD $MinR $MaxR   }
		91  { OrbitTrackData SSIESXY He vD qD $MinR $MaxR  }
		92  { OrbitTrackData SSIESXY O vD qD $MinR $MaxR   }
		93  { OrbitTrackData SSIESXY HF vD qD $MinR $MaxR   }
                100 - 
                101 - 
                102 { 
		   set rList [list H M F]
		   set eS [lindex $rList [expr $V($J) - 100]]
		   set tG [expr $RgI(4) * $RgI(5)]
		   InOutList TOARRAY GriD gmANS(rG$eS) $tG
		   OrbitTrackData CUTXY RATIO GriD vD $MinI 0.0 XY RgI 
                }
	     }
	  }

 for { set W 0 } { $W <= $EnD } { incr W } {
    puts stderr "$W $X($W) $Y($W)"
 }

	  set opX [list <= 0.0]
	  set opY [list 255 <= 0.0 HOLD 8 +]
	  Plot2D $wN Xb Yb X Y 0 $EnD SCATTER $opY $opX

	  PLTinfoChg $wN ALL NUMBERS NSIZE $tS
	  PLTinfoChg $wN ALL NUMBERS TSIZE $tS
	  PLTinfoChg $wN X TICKS MJNUMBER 5
	  PLTinfoChg $wN X TICKS MNNUMBER 5
	  PLTinfoChg $wN Y TICKS MJNUMBER 5
	  PLTinfoChg $wN Y TICKS MNNUMBER 5

	  set LaB [list $xLab 1.0 $yLab 1.0]
	  set NuM [list BOT BOT BOTH BOTH]
	  PlotOutlines $wN $LaB $NuM

          incr wN
      }

      PlotColor HOLD $GphInfo(lColor) OFF
   }

   update

   SetScreen 0 NONE
}
