package provide GMEPlot 1.0

# THIS puts up a MOMENT plot

proc PlotMOM { pN MoMiD } {
   global gmANS GphInfo FDImG FTImG MDImG MTImG HDImG HTImG

   GridParams gI MOMENTS
   DefinePlot $pN $pN
   if { $gmANS(Zoom) >= .9 } { set tS 10 } else { set tS 8 }
                                                                                
   TUgridInfo 30 gI xC
   TUgridInfo 31 gI yC

   set cD $gmANS(cMOMD)
   set cT $gmANS(cMOMT)
   for { set I 0 } { $I < 5 } { incr I } {
      set dMAP($I) [lindex $gmANS($cD) $I]
      set tMAP($I) [lindex $gmANS($cT) $I]
   }

   set iD ""
   switch -exact -- $MoMiD {
      MOMFD {
         Plot3D $pN Xb Yb xC yC FDImG MANUAL gI dMAP
         set iD FD
      }
      MOMFT {
         Plot3D $pN Xb Yb xC yC FTImG MANUAL gI tMAP
         set iD FT
      }
      MOMMD {
         Plot3D $pN Xb Yb xC yC MDImG MANUAL gI dMAP
         set iD MD
      }
      MOMMT {
         Plot3D $pN Xb Yb xC yC MTImG MANUAL gI tMAP
         set iD MT
      }
      MOMHD {
         Plot3D $pN Xb Yb xC yC HDImG MANUAL gI dMAP
         set iD HD
      }
      MOMHT {
         Plot3D $pN Xb Yb xC yC HTImG MANUAL gI tMAP
         set iD HT
      }
   }

   TextProp 10
   TexT $pN 0.0 0.0 0.0 center $iD $GphInfo(White)
   TextProp 12
                                                                                
   PLTinfoChg $pN ALL NUMBERS NSIZE $tS
   PLTinfoChg $pN ALL NUMBERS TSIZE $tS
   PLTinfoChg $pN Xt NUMBERS TSIZE 10
   if { $pN == $gmANS(AnnPlot) } { 
      PlotOutlines $pN [list "X SM" 1 "Y SM" 1] [list BOT BOT BOTH BOTH]
   } else {
      PlotOutlines $pN [list "" 1 "" 1] [list NONE NONE BOTH BOTH]
   }
   update
}
