package provide GMEPlot 1.0

# THIS puts up an EUV simulation plot

proc PlotEUV { pN } {
   global gmANS GphInfo env HeImG HegI

   DefinePlot $pN $pN
   if { $gmANS(Zoom) >= .9 } { set tS 12 } else { set tS 10 }
                                                                                
# GET the start time of the inversion into a pleasent format

   scan $gmANS(HeTIME) "%4s%3s%2s%2s%2s%s" fY fD fH fM fS Rest
   set fH [string trimleft $fH "0"] 
   if { [string length $fH] == 0 } { set fH 0 }
   set fM [string trimleft $fM "0"] 
   if { [string length $fM] == 0 } { set fM 0 }
   set fS [string trimleft $fS "0"] 
   if { [string length $fS] == 0 } { set fS 0 }
   set Tm [format "%d %03d %02d:%02d" $fY $fD $fH $fM] 
   set fBegT [expr ($fH * 3600 + $fM * 60 + $fS) * 1000]
   set fEndT [expr $fBegT + 14 * 60000 ]

   set cI $gmANS(cEUV)
   for { set I 0 } { $I < 5 } { incr I } {
      set cMAP($I) [lindex $gmANS($cI) $I]
   }

   if [string match PT $gmANS(HeFORMAT)] {
      set oPs(0) 1
      PolarPlot  $pN PP PP HeImG HegI oPs cMAP
   } else {
      TUgridInfo 30 HegI xC
      TUgridInfo 31 HegI yC
      Plot3D $pN Xb Yb xC yC HeImG MANUAL HegI cMAP
   }

   TextProp 10
   TexT $pN 0.0 0.0 0.0 center E $GphInfo(White)
   TextProp 12
                                                                                
   PLTinfoChg $pN ALL NUMBERS NSIZE $tS
   PLTinfoChg $pN ALL NUMBERS TSIZE $tS
   PLTinfoChg $pN Xt NUMBERS TSIZE 10
   PLTaxisRec $pN Xt NONE AXIS -0.5 0.0 center $Tm
   if { $pN == $gmANS(AnnPlot) } { 
      PlotOutlines $pN [list "X SM" 1 "Y SM" 1] [list BOT BOT BOTH BOTH]
   } else {
      PlotOutlines $pN [list "" 1 "" 1] [list NONE NONE BOTH BOTH]
   }
   update
}
