package provide GMEPlot 1.0

# THIS gets and plots any SSIES data along the DMSP orbit track

proc OrbitTrackData { Action MiD mA mB MnV MxV {FmT NONE} {gIF ZyXw} } {
   global gmANS env HeImG HegI gLS \
          SvX SvY SvZ SNi SH SHe SO STi STe \
          QvX QvY QvZ QNi QH QHe QO QTi QTe

   upvar $mA Va
   upvar $mB Vb
   if ![string match NONE $FmT] { upvar $gIF igI }

   GridParams gI 2D 
   set tY(0) 0.0
   set BaD -1.0e10

   set DoGrid 1
   if [string match SSIESXY $Action] {
      set Action SSIES
      set DoGrid 0
   } elseif [string match CUTXY $Action] {
      set Action CUT
      set DoGrid 0
   }

   if [string match SSIES $Action] {
      switch -exact -- $MiD {
         TeCp { 
	    set TmP SNi ; upvar 0 $TmP vN
	    set TmP STe ; upvar 0 $TmP vT
	    set TmP QNi ; upvar 0 $TmP qN
	    set TmP QTe ; upvar 0 $TmP qT

            set N 0
            for { set J $gmANS(uB) } { $J <= $gmANS(uE) } { incr J } {
               if { $vN($J) != 0.0 } {
                  set vA($N) [expr $vT($J) * $vN($J)]
	       } else { $vA($N) $BaD }
               if { ($qN($J) < -1.0e-9) && ($qT($J) < -1.0e-9) } {
                  set $vB($N) -1.0e-10
               } else { set vB($N) $vA($N) }
               if { ($vA($N) < $MnV) || ($vA($N) > $MxV) } { set vA($N) $BaD }
	       set lS($N) $gLS($J)
	       incr N
            }
         }
         TiCp { 
	    set TmP SNi ; upvar 0 $TmP vN
	    set TmP STi ; upvar 0 $TmP vT
	    set TmP QNi ; upvar 0 $TmP qN
	    set TmP QTi ; upvar 0 $TmP qT

            set N 0
            for { set J $gmANS(uB) } { $J <= $gmANS(uE) } { incr J } {
               if { $vN($J) != 0.0 } {
                  set vA($N) [expr $vT($J) * $vN($J)]
	       } else { $vA($N) $BaD }
               if { ($qN($J) < -1.0e-9) && ($qT($J) < -1.0e-9) } {
                  set $vB($N) -1.0e-10
               } else { set vB($N) $vA($N) }
               if { ($vA($N) < $MnV) || ($vA($N) > $MxV) } { set vA($N) $BaD }
	       set lS($N) $gLS($J)
	       incr N
            }
         }
         HF {
	    set TmP STe ; upvar 0 $TmP vTe
	    set TmP SNi ; upvar 0 $TmP vN

	    GridParams eGi ETIME
	    set N $eGi(4)
	    for { set I 0 } { $I < $N } { incr I } { 
               if { ($vTe($I) < $MnV) || ($vTe($I) > $MxV) } { 
	           set vT($I) 0.0 ; set NorM($I) 0
               } else { set vT($I) $vTe($I) ; set NorM($I) 1 }
	    }

	    TUgridFill1D vT eGi X LI -1 0 NorM

	    set End 1
	    while { $End <= $N } {
	       set End [expr $End * 2]
	    }
	    for { set I $N } { $I < $End } { incr I } { set vT($I) 0.0 }

            set fOps(0) 280
            set fOps(1) 280
            set fOps(2) 2
            TUdataFilter vT $End SAVITZKYGOLAY fOps SG

            set fOps(0) 40
            set fOps(1) 40
            set fOps(2) 2
            TUdataFilter vT $End SAVITZKYGOLAY fOps SGa

            set fOps(0) 8
            set fOps(1) 8
            set fOps(2) 2
            TUdataFilter vT $End SAVITZKYGOLAY fOps SGb

            set N 0 
            for { set I $gmANS(uB) } { $I <= $gmANS(uE) } { incr I } {
	       if { $SGa($I) < $SG($I) } { 
	          set MiN $SGa($I) 
	       } else { set MiN $SG($I) }
	       if { $MiN > $SGb($I) } { set MiN $SGb($I) }
	       set vA($N) [expr $vT($I) - $MiN]

	       if { ($vA($N) > 0.0) && ($vN($I) > 0.0) } {
	         set vA($N) [expr $vA($N) * log10($vN($I))]
	       }

	       set vB($N) $BaD
	       set lS($N) $gLS($I)
	       incr N
	    }
	 }
         default {
	    set TmP S$MiD ; upvar 0 $TmP vM
	    set TmP Q$MiD ; upvar 0 $TmP vQ
            set N 0
            for { set J $gmANS(uB) } { $J <= $gmANS(uE) } { incr J } {
               set vA($N) $vM($J)
               set vB($N) $vQ($J)
	       set lS($N) $gLS($J)
               if { ($vA($N) < $MnV) || ($vA($N) > $MxV) } { set vA($N) $BaD }
	       incr N
            }
         }
      }

      if $DoGrid {
         TUdataGrid $N 1 lS lS $N tY tY vA Va vNorM gI
         TUgridFill1D Va gI X HM -1 0 vNorM
         TUdataGrid $N 1 lS lS $N tY tY vB Vb vNorM gI
         TUgridFill1D Vb gI X HM -1 0 vNorM
      } else {
         for { set J 0 } { $J < $N } { incr J } {
	    set Va($J) $vA($J)
	    set Vb($J) $vB($J)
         }
      }
   } elseif [string match CUT $Action] {
      set N [GridCut $FmT Va igI oX oZ]
      if $DoGrid {
         TUdataGrid $N 1 oX oX $N tY tY oZ Vb vNorM gI
         if { $MnV > 0.0 } {
            TUgridInfo 0 gI rI $MnV 0.0
            set PoS [expr $rI(0) - 1]
            for { set J 0 } { $J <= $PoS } { incr J } {
	       set vNorM($J) 1.0
	       set V($J) 1.0e-12
	    }
         }
         TUgridFill1D Vb gI X HM -1 0 vNorM
      } else {
         for { set J 0 } { $J < $N } { incr J } {
	    set Va($J) $oZ($J)
	    set Vb($J) $oZ($J)
         }
      }
   }
}
