package provide GMEPlot 1.0

proc NLinFit { fType } {
   global gmANS PI GphInfo eV dF MyX

   set pN $gmANS(curSpN)
   set sN $gmANS(sN)

   if { ($gmANS(MHomits) == 2) || ($gmANS(MHomits) == 3) } {
       set ReT [FormXY eV dF oX oY mAV hAV]
       set mE [lindex $ReT 1]
       set hB [lindex $ReT 1]
       set hE [lindex $ReT 0]
       upvar 0 oX iX
       upvar 0 oY iY
    } else {
       set mE [llength $gmANS(AVAILMENA)]
       set hB [llength $gmANS(AVAILMENA)]
       set hE [expr $hB + [llength $gmANS(AVAILHENA)]]
       upvar 0 eV iX
       upvar 0 dF iY
    } 

# NEED to set up the guesses at the parameters

   set BeG -1
   for { set I 0 ; set J 1 } { $J < $hE } { incr I ; incr J } { 
      set dX [expr $iX($J) - $iX($I)]
      if { ($iY($I) > $iY($J)) && ($dX > 4.0) } { 
         set BeG 1
         break
      }
   }

   if { $BeG < 0 } { return 0 }
   set nBeG [expr $BeG + 1]

# GLOBAL data sets
 
   for { set I 0 } { $I < $hE } { incr I } { 
      set MyX($I) $iX($I)
      set MyY($I) $iY($I)
      set MyS($I) $iY($I)
   }

# DO the fit

   switch -exact -- $fType {
      MAXWELLIAN {
         set yA [expr log($iY($BeG))]
         set yB [expr log($iY($nBeG))]
         set xA $iX($BeG)
         set xB $iX($nBeG)
                                                                                
         set A(1) [expr -($xA - $xB) / ($yA - $yB)]
         set A(0) [expr $yA + $xA/$A(1)]
         set A(0) [expr exp($A(0))]
         set A(1) [expr 1.0 / $A(1)]

         set BeG [expr $hE - 3]
         set nBeG [expr $hE - 2]
         set yA [expr log($iY($BeG))]
         set yB [expr log($iY($nBeG))]
         set xA $iX($BeG)
         set xB $iX($nBeG)
                                                                                
         set A(3) [expr -($xA - $xB) / ($yA - $yB)]
         set A(2) [expr $yA + $xA/$A(3)]
         set A(2) [expr exp($A(2))]
         set A(3) [expr 1.0 / $A(3)]

         set nC 4

         set iA(0) 1 ; set iA(1) 1 ; set iA(2) 1 ; set iA(3) 1 
         set FunC FitMaxwellian

      } 
      KAPPA {
         set yA [expr log($iY($BeG))]
         set yB [expr log($iY($nBeG))]
         set xA $iX($BeG)
         set xB $iX($nBeG)
                                                                                
         set A(1) [expr -($xA - $xB) / ($yA - $yB)]
         set A(0) [expr $yA + $xA/$A(1)]
         set A(0) [expr exp($A(0))]
         set A(2) 4.0
         set A(1) [expr 1.0 / $A(1) / $A(2)]

         set nC 3
         set iA(0) 1 ; set iA(1) 1 ; set iA(2) 1 
         set FunC FitKappa
      }
   }

   set oP(0) -1.0
   TUdataNLinLSq MyY MyS $hE A iA $nC $FunC oP
   set I 0
   while { ($I < 200) && ($oP(0) < 1.0e3) } {
      TUdataNLinLSq MyY MyS $hE A iA $nC $FunC oP
      incr I
   }
   set oP(0) 0.0
   TUdataNLinLSq MyY MyS $hE A iA $nC $FunC oP

   if [string match YES $gmANS(showFIT)] {
      switch -exact -- $fType {
         MAXWELLIAN {
           for { set I 0 } { $I < 79 } { incr I } {
              set E  [expr double($I + 1)]
              set X($I) $E
              set Y($I) [expr $A(0) * exp(-$E * $A(1)) + \
                              $A(2) * exp(-$E * $A(3))]
           }
         }
         KAPPA {
           for { set I 0 } { $I < 79 } { incr I } {
              set E  [expr double($I + 1)]
              set X($I) $E
              set Aa [expr 1.0 + $A(1) * $X($I)]
              set Ba [expr pow($Aa,-$A(2))]
              set Y($I) [expr $A(0) * $Ba]
           }
         }
      }

      set W .sWin$pN
      SetScreen 1 $W.sp
      PlotColor HOLD $GphInfo([lindex $gmANS(pCol) $gmANS(curCP)]) HOLD
      set GphInfo(tag) XY[expr $sN - 1]
      Lines $pN X Y X $I
      set GphInfo(tag) ""
      SetScreen 0 NONE
   }

   if { $gmANS(curC) >= 0 } {
      set State [lindex $gmANS(sPS) $gmANS(curC)] 
      if [string match OPEN $State] { return }
   } else { return }
        
   if { $gmANS(momID) == 0 } {
      switch -exact -- $fType {
         MAXWELLIAN {
            set rV(1) [expr 1.0 / $A(1)]
            set T1    [expr 1.67e-24 / 1.602e-12 / $PI / 2000.0 / $rV(1)]
            set rV(0) [expr $A(0) / $T1 / sqrt($T1)]
            set rV(3) [expr 1.0 / $A(3)]
            set T1    [expr 1.67e-24 / 1.602e-12 / $PI / 2000.0 / $rV(3)]
            set rV(2) [expr $A(2) / $T1 / sqrt($T1)]
            set rV(0) [format "%6.2f D1" $rV(0)]
            set rV(1) [format "%6.2f T1" $rV(1)]
            set rV(2) [format "%6.2f D2" $rV(2)]
            set rV(3) [format "%6.2f T2" $rV(3)]
         }
         KAPPA {
            set rV(2) [expr $A(2) - 1.0]
            set rV(1) [expr $rV(2) * (1.0 - 1.5 / $rV(2)) / $A(1) ]
            set T1 [expr $A(1) * 1.67e-24 / 1.602e-12 / $PI / 2000.0 ]
            set G1 [expr $rV(2) + 1]
            set G2 [expr $rV(2) - .5]
            set T2 [expr [TUgammaFn $G1 LGAMMA] - [TUgammaFn $G2 LGAMMA]]
            set rV(0) [expr $A(0) / exp($T2) / $T1 / sqrt($T1)]
            set rV(0) [format "%6.2f  D" $rV(0)]
            set rV(1) [format "%6.2f  T" $rV(1)]
            set rV(2) [format "%6.2f  K" $rV(2)]
            set rV(3) ""
         }
      }

      set P $gmANS(curC)
      if { $P >= 0 } {
         for { set I 0 ; set J 2 } { $I < 4 } { incr I ; incr J } {
            $W.info.r${J}c$P delete 0 end
            if { [string length $rV($I)] > 0 } { 
               set C [lindex $gmANS(gCol) $gmANS(curCP)]
               $W.info.r${J}c$P insert end $rV($I)
               $W.info.r${J}c$P configure -fg $C
            }
         }
      }
   }
}
