package provide GMEPlot 1.0

proc MomMaps { } {
   global gmANS 

   set MinR2 [expr $gmANS(ionLow) * $gmANS(ionLow)]
   GridParams gI MOMENTS

   set tG [expr $gI(4) * $gI(5)] 

   if $gmANS(LoadPF) {
      set gmANS(FDG) ""
      set gmANS(FTG) ""
      for { set I 0 } { $I < $tG } { incr I } {
         TUgridInfo 20 gI rV $I
         set R [expr $rV(2) * $rV(2) + $rV(3) * $rV(3)]
         if { $R >= $MinR2 } {
            GetSpectra eV dF $rV(2) $rV(3)
            set MoM [RCMapMom eV dF FULL]
            lappend gmANS(FDG) [lindex $MoM 0] 
            lappend gmANS(FTG) [lindex $MoM 1] 
         } else {
            lappend gmANS(FDG) 0.0
            lappend gmANS(FTG) 0.0
         }
      }
   } 

   if $gmANS(LoadPS) {
      set gmANS(hdG) ""
      set gmANS(htG) ""
      set gmANS(mdG) ""
      set gmANS(mtG) ""
      for { set I 0 } { $I < $tG } { incr I } {
         TUgridInfo 20 gI rV $I
         set R [expr $rV(2) * $rV(2) + $rV(3) * $rV(3)]
         if { $R >= $MinR2 } {
            GetSpectra eV dF $rV(2) $rV(3)
            set MoM [RCMapMom eV dF SPLIT]
            lappend gmANS(MDG) [lindex $MoM 0] 
            lappend gmANS(MTG) [lindex $MoM 1] 
            lappend gmANS(HDG) [lindex $MoM 2] 
            lappend gmANS(HTG) [lindex $MoM 3] 
         } else {
            lappend gmANS(MDG) 0.0
            lappend gmANS(MTG) 0.0
            lappend gmANS(HDG) 0.0
            lappend gmANS(HTG) 0.0
	 }
      }
   }
}
