package provide GMEPlot 1.0

# THIS gets the DMSP orbit track if there is a DMSP overlay

proc HENAOrbTrackPlot { } {
   global gmANS env gIH

# SEE if we need to put up a cut through an EUV inversion plot

   set pI [PlotCheck 40 59]
   set nP [llength $pI]
   if { $nP == 0 } { return }
   set nE $gmANS(nOrbit)

   GridParams gI 2D 
   TUgridInfo 32 gI xC
   set EnD [expr $gI(4) - 1] 
   set tG [expr $gIH(4) * gIH(5)] 

   for { set I 0 } { $I < $nP } { incr I } {
      set tP [split [lindex $pI $I] "|"]
      set wN [lindex $tP 0]
      set yA [lindex $tP 1]
      set Q  [lindex $tP 2]
      if [string match Yb $yA] {
         set pC $gmANS(clh)
      } else { set pC $gmANS(crh) }

      set Pri -1
      set Sec ""
      switch -exact -- $Q {
         40 -
         41 -
         42 -
         43 -
         44 -
         45 { set Pri [expr $Q - 40]            }
         46 { set Pri 1 ; set Sec [list 2 3]     }
         47 { set Pri 2 ; set Sec [list 3 4]     }
         48 { set Pri 1 ; set Sec [list 3 4]     }
         49 { set Pri 1 ; set Sec [list 3 5]     }
         50 { set Pri 1 ; set Sec 3              }
         51 { set Pri 2 ; set Sec 4              }
         52 { set Pri 1 ; set Sec [list 2 3 4 5] }
      }

      set MinR $gmANS(ionLow)
      if { $Pri >= 0 } {
         if { [lsearch $gmANS(AVAILHENA) $Pri] >= 0 } {
	    InOutList TOARRAY GriD gmANS(hG$Pri) $tG
	    OrbitTrackData CUT HENA GriD V $MinR 0.0 PT gIH
            if [string match Yb $yA] {
               set pC $gmANS(clh)
            } else { set pC $gmANS(crh) }
            Plot2D $wN Xb $yA xC V 0 $EnD LINE [list $pC < 0.5]
         }
      }
      set nS [llength $Sec]
      if { $nS > 0 } {
         for { set J 0 } { $J < $nS } { incr J } {
            set eC [lindex $Sec $J]
            set pC $gmANS(cex$gmANS(pN${wN}eC))
            incr gmANS(pN${wN}eC)
            if { [lsearch $gmANS(AVAILHENA) $eC] >= 0 } {
	       InOutList TOARRAY GriD gmANS(hG$eC) $tG
	       OrbitTrackData CUT HENA GriD V $MinR 0.0 PT gIH
               Plot2D $wN Xb $yA xC V 0 $EnD LINE [list $pC < 0.5]
            }
            lappend gmANS(Q$Q) $pC
         }
      }
   }
   update
}
