package provide GMEPlot 1.0

# THIS gets the DMSP orbit track if there is a DMSP overlay

proc GridCut { GridFmt Grid gInfo X Z } {
   global gmANS env RtoD gLS gMLT

   upvar $X oX
   upvar $Z oZ
   upvar $Grid G
   upvar $gInfo gI

   set N 0
   if [string match PT $GridFmt] {
      for { set I $gmANS(uB) } { $I <= $gmANS(uE) } { incr I } {
         set oX($N) $gLS($I)
         set oY [expr 360.0 * ($gMLT($I) - 12.0) / 24.0 / $RtoD]
         TUgridInfo 0 gI rV $oY $oX($N)
         if { $rV(0) >= 0 } {
            if { $G($rV(0)) > 0.0 } {
              set oZ($N) $G($rV(0))
            } else { set oZ($N) 1.0e-10 }
         } else { set oZ($N) 1.0e-10 }
	 incr N
      }
   } else {
      for { set I $gmANS(uB) } { $I <= $gmANS(uE) } { incr I } {
         set oX($N) $gLS($I)
         set AnG [expr 360.0 * ($gMLT($I) - 12.0) / 24.0 / $RtoD]
         set X [expr $oX($N) * cos($AnG)]
         set Y [expr $oX($N) * sin($AnG)]
         TUgridInfo 0 gI rV $X $Y
         if { $rV(0) >= 0 } {
            if { $G($rV(0)) > 0.0 } {
              set oZ($N) $G($rV(0))
            } else { set oZ($N) -1.0e10 }
         } else { set oZ($N) -1.0e10}
	 incr N
      }
   }

   return $N
}
