package provide GMEPlot 1.0

# THIS is the interface which allows you to add DMSP data into the mix

proc DMSPGui { tW } {
   global gmANS GphInfo env

# LAY out the window names for the GUI frame structure
                                                                                
   set W  .dmsp
   set Wa .dmsp.ctrl
   set Wb .dmsp.opts
   set Wc .dmsp.parm

# IF no menu needed then leave.  Destroy any menu which may already
#  exist.  ONLY do this if we got her via the toggle button!

   if {[string length $tW] > 0 } {
      GUIoptsToggle $tW gmANS(DmSp) PRI
      if [string match NO $gmANS(DmSp)] {
         if [winfo exists $W] { destroy $W }
         return
      }
   }

   set ScOps [list LINEAR|0 LOG|1]
   set StOps [list DMSP-F12 DMSP-F13 DMSP-F14 DMSP-F15]
   set LcOps [list BOTTOM|0 RIGHT|2 ]
                                                                           
   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "ADD DMSP PLOTS"
                                                                                
      GUIFrame $Wa -1 pack|top||x
      GUIFrame $Wb -1 pack|top|nw
      GUIFrame $Wc -1 pack|top||x

      GUIboxEntry $Wa.br  pack|left 7 gmANS(PlotBrk)
      GUILabel $Wa.blab "Break Point" c pack|left
      GUIbuttonPush $Wa.close Close pack|right "wm iconify $W" 6
      
      set Row 0
      GUILabel $Wb.pllab "Location of Plots"  w grid|$Row|0|w
      GUIbuttonMenu $Wb.ploc $gmANS(pLoc) grid|$Row|1|||2 $LcOps  \
           "GUIoptsProcess $Wb.ploc gmANS(pLoc) PRI " 6

      incr Row
      GUILabel $Wb.sclab "DMSP Satellite"  w grid|$Row|0|w
      GUIbuttonMenu $Wb.sat $gmANS(DMSPsat) grid|$Row|1|||2 $StOps  \
           "GUIoptsProcess $Wb.sat gmANS(DMSPsat) PRI " 6

      incr Row
      GUILabel $Wb.btlab "Beg Time (YDHMS)"  w grid|$Row|0|w
      GUIboxEntry $Wb.byr  grid|$Row|1|w 5 gmANS(bYr)
      GUIboxEntry $Wb.bdy  grid|$Row|2|w 4 gmANS(bDy)
      GUIboxEntry $Wb.bhr  grid|$Row|3|w 3 gmANS(bHr)
      GUIboxEntry $Wb.bmn  grid|$Row|4|w 3 gmANS(bMn)
      GUIboxEntry $Wb.bsc  grid|$Row|5|w 3 gmANS(bSc)

      incr Row
      GUILabel $Wb.etlab "End Time (YDHMS)"  w grid|$Row|0|w
      GUIboxEntry $Wb.eyr  grid|$Row|1|w 5 gmANS(eYr)
      GUIboxEntry $Wb.edy  grid|$Row|2|w 4 gmANS(eDy)
      GUIboxEntry $Wb.ehr  grid|$Row|3|w 3 gmANS(eHr)
      GUIboxEntry $Wb.emn  grid|$Row|4|w 3 gmANS(eMn)
      GUIboxEntry $Wb.esc  grid|$Row|5|w 3 gmANS(eSc)

      set Row 0
      set C #FF0000
      set FonT [list fixed 12 bold]
      GUIblankRow $Wc $Row 1.0
      incr Row
      GUILabel $Wc.mlab "PLOT DEFINITIONS" center grid|$Row|0|ew||5 0 0 "" $FonT
      incr Row
      GUIblankRow $Wc $Row 1.0
      incr Row
      GUILabel $Wc.plab "PLOT"     center grid|$Row|0|ew 0 0 $C
      GUILabel $Wc.qlab "QUANTITY" center grid|$Row|1|ew 0 0 $C
      GUILabel $Wc.mnlab "MINIMUM" center grid|$Row|2|ew 0 0 $C
      GUILabel $Wc.mxlab "MAXIMUM" center grid|$Row|3|ew 0 0 $C
      GUILabel $Wc.sclab "SCALE"   center grid|$Row|4|ew 0 0 $C
      GUILabel $Wc.mnrlab "MIN CUT" center grid|$Row|5|ew 0 0 $C
      GUILabel $Wc.mxrlab "MAX CUT" center grid|$Row|6|ew 0 0 $C
      incr Row

      set FonT [list fixed 12 bold]
      for { set I 0 } { $I < $gmANS(nLP) } { incr I } { 
         for { set J 0 } { $J < 2 } { incr J } { 
            set iD $I$J
            set LaB "$I.$J"
            GUILabel $Wc.pq${iD}lab $LaB w grid|$Row|0|w 

            GUIbuttonMenu $Wc.q${iD} "" grid|$Row|1|ew $gmANS(MsOps)  \
                "GUIoptsProcess $Wc.q${iD} gmANS(Q${iD}) ALT " 6 -1 "" left
            set LaB [GUIoptsInfo $Wc.q$iD OPTV $gmANS(Q${iD}) ALT PRI]
            $Wc.q${iD} configure -text $LaB
            GUIboxEntry $Wc.p${iD}min  grid|$Row|2|ew 9 gmANS(P${iD}Min)
            GUIboxEntry $Wc.p${iD}max  grid|$Row|3|ew 9 gmANS(P${iD}Max)
            GUIbuttonToggle $Wc.p{$iD}sca $gmANS(P${iD}Sca) grid|$Row|4|ew \
                 $ScOps "GUIoptsToggle $Wc.p{$iD}sca gmANS(P${iD}Sca) PRI " 6
            GUIboxEntry $Wc.p${iD}rmin  grid|$Row|5|ew 9 gmANS(P${iD}MinR)
            GUIboxEntry $Wc.p${iD}rmax  grid|$Row|6|ew 9 gmANS(P${iD}MaxR)
            incr Row
         }
      }
   }

   update
}
