package provide GMEPlot 1.0

# THIS assembles a full MENA 2D set of energy inversions.

proc AssembleMENA { } {
   global gmANS GphInfo env gIM

   set gmANS(AVAILMENA) ""
   set gmANS(MbE) ""
   set gmANS(MeE) ""

   GridParams gIM MENA
   set tG [expr $gIM(4) * $gIM(5)]

   set bN $gmANS(MENAFILE)

   set nF [llength $gmANS(MiD)]
   set mOrd ""
   for { set I 0 } { $I < $nF } { incr I } {
      set fN [file join $gmANS(MENAHOME) $bN[lindex $gmANS(MiD) $I].inv]
      if ![file exists $fN] { continue }
      set nP [IonInvRead $fN Xs Ys Ds AnC 1 xX yY UA XY]
      if {[lindex $nP 2] > 0 } {
         lappend mOrd [list $I [expr 1000.0 * $AnC(KeV)]]
         TUdataGrid [lindex $nP 2] 1 Xs xX 1 Ys yY Ds GriD gNorM gIM
	 InOutList TOLIST GriD gmANS(mG$I) $tG
      }
   }

   set nF [llength $mOrd]
   set mOrd [lsort -increasing -real -index 1 $mOrd]
   for { set I 0 } { $I < $nF } { incr I } {
      lappend gmANS(AVAILMENA) [lindex [lindex $mOrd $I] 0]
      lappend gmANS(MbE) [lindex [lindex $mOrd $I] 1]
      lappend gmANS(MeE) [lindex [lindex $mOrd $I] 1]
   }
}
