package provide TclFFT_C 1.0

#  FOURIER TRANSFORM OF TWO REAL FUNCTIONS 
#
#    DaTa1:  Input data array 1 - length N
#    DaTa2:  Input data array 2 - length N
#    FfT1:   FFT of array 1 - length N
#    FfT2:   FFT of array 2 - length N
#    N:     Length of data array - must be power of 2

proc TwoFfT { DaTa1 DaTa2 FT1 FT2 N } {

   global TwoPI

   upvar $DaTa1 A
   upvar $DaTa2 B
   upvar $FT1  C
   upvar $FT2  D

   set nP [expr $N << 1]

   set J 0
   for { set I 0 } { $I < $N } { incr I } {
      set C($J) $A($I) ; incr J
      set C($J) $B($I) ; incr J
   }

   FfT C $N 1

   set D(0) $C(1)
   set C(1) 0.0
   set D(1) 0.0

   set J 2
   set K [expr $nP - 2]
   set L [expr $nP - 1]
   set EnD [expr $N + 2]
   for { set I 2 } { $I < $EnD } { incr I ; incr K -3 } {
      set ReP [expr 0.5 * ($C($I) + $C($K))]
      set ReM [expr 0.5 * ($C($I) - $C($K))]
      incr I; incr K 
      set AiP [expr 0.5 * ($C($I) + $C($K))]
      set AiM [expr 0.5 * ($C($I) - $C($K))]
      set C($J) $ReP
      set D($J) $AiP ; incr J
      set C($J) $AiM
      set D($J) [expr -$ReM] ; incr J
      set C($L) [expr -$AiM]
      set D($L) $ReM ; incr L -1
      set C($L) $ReP
      set D($L) $AiP ; incr L -1
   }
}
