package provide TclFFT_C 1.0

#  FOURIER TRANSFORM OF REAL FUNCTIONS 
#
#    DaTa :  Input data array - length N
#    N:      Length of data array - must be power of 2
#    Fmt:    1  - compute fft tranformation of data
#           -1 - compute inverse transformation 

proc RealFfT { DaTa N Fmt } {

   global PI

   upvar $DaTa A

   set nP [expr $N >> 1]

   set ThetA [expr $PI / double($nP)]
   if { $Fmt == 1 } {
      set C -0.5
      FfT A $nP 1
   } else {
      set C  0.5
      set ThetA [expr -$ThetA]
   }

   set TmP [expr sin (0.5 * $ThetA)]
   set pR  [expr -2.0 * $TmP * $TmP]
   set pI  [expr sin ($ThetA)]
   set Re  [expr 1.0 + $pR]
   set Im  $pI

   set J 2
   set K [expr $N - 2]
   set L [expr $N - 1]
   for { set I 2 } { $I < $nP } { incr I ; incr K -3 } {
      set h1r [expr 0.5 * ($A($I) + $A($K))] 
      set h2i [expr $C * ($A($I) - $A($K))] 
      incr I; incr K
      set h2r [expr -$C * ($A($I) + $A($K))] 
      set h1i [expr 0.5 * ($A($I) - $A($K))]

      set A($J) [expr $h1r + $Re * $h2r - $Im * $h2i] 
      incr J
      set A($J) [expr $h1i + $Re * $h2i + $Im * $h2r]
      incr J
      set A($L) [expr -$h1i + $Re * $h2i + $Im * $h2r]
      incr L -1
      set A($L) [expr $h1r - $Re * $h2r + $Im * $h2i]
      incr L -1


      set TmP $Re
      set Re [expr $Re * $pR - $Im * $pI + $Re]
      set Im [expr $Im * $pR + $TmP * $pI + $Im]
   }

   set TmP $A(0)
   if { $Fmt == 1 } {
      set A(0) [expr $A(0) + $A(1)]
      set A(1) [expr $TmP - $A(1)]
   } else {
      set A(0) [expr 0.5 * ($A(0) + $A(1))]
      set A(1) [expr 0.5 *($TmP - $A(1))]
      FfT A $nP -1
   }
}
