package provide TclFFT_C 1.0

# MAXIMUM ENTROPY COEFFICIENT GENERATOR
#
#    DaTa:  Input data array and output transform
#    nP:    Length of data array 
#    nC:    Number of prediction coefficients to retirn
#    CoeF:  The returned coefficients
#
#    RETURNS: mean square error

proc MaxEntCoef { DaTa nP nC CoeF } {

   upvar $DaTa   D
   upvar $CoeF   C

   set LastC [expr $nC - 1]

   set SuM 0.0
   for { set I 0 } { $I < $nP } { incr I } { 
      set SuM [expr $SuM + $D($I) * $D($I)]
   }
   set rV [expr $SuM / double($nP)]

   set EnD [expr $nP - 1]
   for { set I 0 } { $I < $EnD } { incr I } { set T1($I) $D($I) }
   for { set I 0 ; set J 1 } { $I < $EnD } { incr I ; incr J } { 
      set T2($I) $D($J) 
   }

   for { set I 0 } { $I < $nC } { incr I } { 
      set NuM 0.0
      set DeNoM 0.0
      set EnD [expr $nP - $I - 1]
      for { set J 0 } { $J < $EnD } { incr J } { 
         set NuM [expr $NuM + $T1($J) * $T2($J)]
         set DeNoM [expr $DeNoM + $T1($J) * $T1($J) + $T2($J) * $T2($J)]
      }
      set C($I) [expr 2.0 * $NuM / $DeNoM]
      set rV [expr $rV  * (1.0 - $C($I) * $C($I))]

      set K [expr $I - 1]
      for { set J 0 } { $J < $I } { incr J ; incr K -1 } { 
         set C($J) [expr $T3($J) -  $C($I) * $T3($K)]
      }
      if { $I == $LastC } { return $rV }
      for { set J 0 } { $J <= $I } { incr J } { set T3($J) $C($J) } 

      set EnD [expr $nP - $I - 2]
      for { set J 0 ; set K 1 } { $J < $EnD } { incr J ; incr K } { 
         set T1($J) [expr $T1($J) - $T3($I) * $T2($J)]
         set T2($J) [expr $T2($K) - $T3($I) * $T1($K)]
      }
   }

   return -1
}
