package provide TclFFT_C 1.0

# DESCRETE FOURIER TRANSFORM 
#
#    DaTa:  Input data array and output transform
#    N:     Length of data array - must be power of 2
#           NOTE: The real length of the array is 2N since there are N real
#                 values and N imaginary values
#    Fmt:   1 - Data array is real 
#          -1 - Data array is complex (N real and N complex values)

proc FfT { DaTa N Fmt } {

   global TwoPI

   upvar $DaTa   D

   if [string match REAL Fmt] { set Fmt 1 }
   if [string match COMPLEX Fmt] { set Fmt -1 }

   set N [expr $N << 1]

   set J 0
   set L 1
   for { set I 0 ; set K 1 } { $I < $N } { incr I 2 ; incr K 2 } {
      if { $J > $I } {
         set TmP   $D($J)
         set D($J) $D($I)
         set D($I) $TmP
         set TmP   $D($K)
         set D($K) $D($L)
         set D($L) $TmP
      }
      set M [expr $N >> 1]
      while { ($M >= 2) && ($J >= $M) } {
         set J [expr $J - $M]
         set M [expr $M >> 1]
      }
      incr J $M
      set L [expr $J + 1]
   }

   set MaX 2
   while { $N > $MaX } {
      set SteP [expr $MaX << 1]
      set ThetA [expr $Fmt * $TwoPI / $MaX]
      set TmP [expr sin (0.5 * $ThetA)]
      set pR [expr -2.0 * $TmP * $TmP]
      set pI [expr sin ($ThetA)]
      set Re 1.0
      set Im 0.0
      for { set M 0 } { $M < $MaX } { incr M 2 } {
         for { set I $M } { $I < $N } { incr I $SteP } {
             set J [expr $I + $MaX]
             set K [expr $J + 1]
             set L [expr $I + 1]
             set rTmP [expr $Re * $D($J) - $Im * $D($K)]
             set iTmP [expr $Re * $D($K) + $Im * $D($J)]
             set D($J) [expr $D($I) - $rTmP]
             set D($K) [expr $D($L) - $iTmP]
             set D($I) [expr $D($I) + $rTmP]
             set D($L) [expr $D($L) + $iTmP]
         }

         set TmP $Re 
         set Re [expr $Re * $pR - $Im * $pI + $Re]
         set Im [expr $Im * $pR + $TmP * $pI + $Im]
      }
      set MaX $SteP
   }
}
