/*  The C equivalent of TwoFfT,  It consists of a TCL interface over a      */
/*  straight C subroutine                                                   */
/*                                                                          */
/*  There are 6 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Data array 1                                               */
/*     OBJV[2]:  Data array 2                                               */
/*     OBJV[3]:  FFT of array 1                                               */
/*     OBJV[4]:  FFT of array 2                                               */
/*     OBJV[5]:  Length of data array                                       */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TfftAnsi.h"
#include "TutilAnsi.h"
                                                                                
int TwoFfTCmd (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv)
{
   void *memPtr = NULL;
   ReaL_8 *V1, *V2, *F1, *F2;
   int nP, Bytes;
   ByTe_4 rV; 
                                                                                
/* Make sure that all the IO parameters are present */
                                                                                
   if (objc != 6 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: TwoFfT Data1 Data2 FFT1 GFFT2 nP");
     return TCL_ERROR;
   }
                                                                                
/* Get the non-array inputs                                              */
                                                                               
   Tcl_GetIntFromObj (tI, objv[5], &nP);
                                                                                
/*  MALLOC memory to hold the data array                                 */
                                                                                
   Bytes = 6 * sizeof(ReaL_8) * nP;
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }
   V1 = (ReaL_8 *)memPtr;
   V2 = (ReaL_8 *)V1 + nP;
   F1 = (ReaL_8 *)V2 + nP;
   F2 = (ReaL_8 *)F1 + 2 * nP;

/*  TRANSFER data array 1                                                */

   if (TclArrayToC (tI, objv[1], (void *)V1, nP, 0, 'D') == 0) {
      free (memPtr);
      return TCL_OK;
   }

/*  TRANSFER data array 2                                                */

   if (TclArrayToC (tI, objv[2], (void *)V2, nP, 0, 'D') == 0) {
      free (memPtr);
      return TCL_OK;
   }

/* CALL the C routine                                                    */

  rV = TwoFfTCmd_C (V1, V2, F1, F2, nP);

/* FFT data arrays to Tcl                                                */


  CArrayToTcl (tI, objv[3], F1, 2 * nP, 0, 'D');
  CArrayToTcl (tI, objv[4], F2, 2 * nP, 0, 'D');
                                                                                
/* Get rid of the temporary array and return                             */
                                                                                
   free (memPtr);
   return TCL_OK;
}

/* THE C ROUTINE                                                         */
                                                                                
                                                                                
ByTe_4 TwoFfTCmd_C (ReaL_8 *V1, ReaL_8 *V2, ReaL_8 *F1, ReaL_8 *F2, int Np)
{
   ReaL_8 ReP, ReM, AiP, AiM;
   ByTe_4 I, J, K, L, nP, EnD;

   nP = Np << 1;

   J = 0;
   for ( I = 0;  I < Np;  I++ ) {
      F1[J++] = V1[I];
      F1[J++] = V2[I];
   }
   FfTCmd_C(F1, Np, 1);

   F2[0] = F1[1];
   F1[1] = 0.0;
   F2[1] = 0.0;

   J = 2;
   K = nP - 2;
   L = nP - 1;
   EnD = Np + 2;
   for ( I = 2; I < EnD; ++I, K -= 3) {
      ReP = 0.5 * (F1[I] + F1[K]);
      ReM = 0.5 * (F1[I++] - F1[K++]);
      AiP = 0.5 * (F1[I] + F1[K]);
      AiM = 0.5 * (F1[I] - F1[K]);
      F1[J] = ReP;
      F2[J++] = AiP;
      F1[J] = AiM;
      F2[J++] = -ReM;
      F1[L] = -AiM;
      F2[L--] = ReM;
      F1[L] = ReP;
      F2[L--] = AiP;
   }

   return (1);
}
