#include <tcl.h>

int FfTCmd (ClientData clientData, Tcl_Interp *interp,
               int objc, Tcl_Obj *CONST *objv); 
int FfTConvolveCmd (ClientData clientData, Tcl_Interp *interp,
               int objc, Tcl_Obj *CONST *objv); 
int MxEntCCmd (ClientData clientData, Tcl_Interp *interp,
               int objc, Tcl_Obj *CONST *objv); 
int MxEntPCmd (ClientData clientData, Tcl_Interp *interp,
               int objc, Tcl_Obj *CONST *objv); 
int RealFfTCmd (ClientData clientData, Tcl_Interp *interp,
               int objc, Tcl_Obj *CONST *objv); 
int TwoFfTCmd (ClientData clientData, Tcl_Interp *interp,
               int objc, Tcl_Obj *CONST *objv); 

int Tclfft_Init (Tcl_Interp *interp) {
   Tcl_CreateObjCommand (interp, "FfT", FfTCmd,
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "FfTConvolve", FfTConvolveCmd,
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "MaxEntCoef", MxEntCCmd,
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "MaxEntPwr", MxEntPCmd,
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "RealFfT", RealFfTCmd,
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "TwoFfT", TwoFfTCmd,
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_PkgProvide(interp, "TclFFT_C",  "2.0");

   return TCL_OK;
}
