/*  The C equivalent of RealFfT,  It consists of a TCL interface over a     */
/*  straight C subroutine                                                   */
/*                                                                          */
/*  There are 4 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Data array                                                 */
/*     OBJV[2]:  Length of data array                                       */
/*     OBJV[3]:  Processing Flag                                            */
/*                   1 - compute FFT                                        */
/*                  -1 - compute inverse transformation                     */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TfftAnsi.h"
#include "TutilAnsi.h"
                                                                                
int RealFfTCmd (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv)
{
   void *memPtr = NULL;
   ReaL_8 *V;
   int nP, pFlg, Bytes;
   ByTe_4 rV; 
                                                                                
/* Make sure that all the IO parameters are present */
                                                                                
   if (objc != 4 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: RealFfT Data nP DataType");
     return TCL_ERROR;
   }
                                                                                
/* Get the non-array inputs                                              */
                                                                               
   Tcl_GetIntFromObj (tI, objv[2], &nP);
   Tcl_GetIntFromObj (tI, objv[3], &pFlg);
                                                                                
/*  MALLOC memory to hold the data array                                 */
                                                                                
   Bytes = sizeof(ReaL_8) * nP;
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }
   V = (ReaL_8 *)memPtr;

/*  TRANSFER the data                                                    */

   if (TclArrayToC (tI, objv[1], (void *)V, nP, 0, 'D') == 0) {
      free (memPtr);
      return TCL_OK;
   }
 
/* CALL the C routine                                                    */

  rV = RealFfTCmd_C (V, nP, pFlg);

/* DATA ARRAY back to Tcl                                                */

  CArrayToTcl (tI, objv[1], V, nP, 0, 'D');
                                                                                
/* Get rid of the temporary array and return                             */
                                                                                
   free (memPtr);
   return TCL_OK;
}

/* THE C ROUTINE                                                         */
                                                                                
                                                                                
ByTe_4 RealFfTCmd_C (ReaL_8 *V, int Np, int pFlg)
{
   ReaL_8 PI = 3.14159265358979323846;
   ReaL_8 TmP;
   ReaL_8 C, ThetA, pR, pI, Re, Im;
   ReaL_8 h1r, h2r, h1i, h2i;
   ByTe_4 I, J, K, L, nP;

   nP = Np >> 1;
   ThetA = PI / (ReaL_8)nP;
   if ( pFlg == 1 ) {
      C = -0.5;
      FfTCmd_C (V, nP, 1);
   } else {
      C = 0.5;
      ThetA = -ThetA;
   }

   TmP = sin(0.5 * ThetA);
   pR = -2.0 * TmP * TmP;
   pI = sin(ThetA);
   Re = 1.0 + pR;
   Im = pI;

   J = 2;
   K = Np - 2;
   L = Np - 1;
   for ( I = 2; I < nP; ++I , K -= 3 ) {
      h1r = 0.5 * (V[I] + V[K]); 
      h2i = C * (V[I++] - V[K++]); 
      h2r = -C * (V[I] + V[K]); 
      h1i = 0.5 * (V[I] - V[K]);

      V[J++] = h1r + Re * h2r - Im * h2i; 
      V[J++] = h1i + Re * h2i + Im * h2r;
      V[L--] = -h1i + Re * h2i + Im * h2r;
      V[L--] = h1r - Re * h2r + Im * h2i;

      TmP = Re;
      Re =  Re * pR - Im * pI + Re;
      Im =  Im * pR + TmP * pI + Im;
   }

   TmP = V[0];
   if ( pFlg == 1 ) {
      V[0] = V[0] + V[1];
      V[1] = TmP - V[1];
   } else {
      V[0] = 0.5 * (V[0] + V[1]);
      V[1] = 0.5 * (TmP - V[1]);
      FfTCmd_C(V, nP, -1);
   }

   return(1);
}
