/*  The C equivalent of MaxEntCoef,  It consists of a TCL interface over a  */
/*  straight C subroutine                                                   */
/*                                                                          */
/*  There are 5 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Data array                                                 */
/*     OBJV[2]:  Length of data array                                       */
/*     OBJV[3]:  Length of coefficient array                                */
/*     OBJV[4]:  Coefficient array                                          */


#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TfftAnsi.h"
#include "TutilAnsi.h"
                                                                                
int MxEntCCmd (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv)
{
   void *memPtr = NULL;
   ReaL_8 *V, *C;
   int nP, nC, Bytes;
   ReaL_8 rV;

   Tcl_Obj *objPtr;
                                                                                
/* Make sure that all the IO parameters are present */
                                                                                
   if (objc != 5 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: FfT Data nP DataType");
     return TCL_ERROR;
   }
                                                                                
/* Get the non-array inputs                                              */
                                                                               
   Tcl_GetIntFromObj (tI, objv[2], &nP);
   Tcl_GetIntFromObj (tI, objv[3], &nC);
                                                                                
/*  MALLOC memory to hold the data array                                 */
                                                                                
   Bytes = sizeof(ReaL_8) * (nP + nC);
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }
   V = (ReaL_8 *)memPtr;
   C = (ReaL_8 *)memPtr + nP;

/*  TRANSFER the data                                                    */

   if (TclArrayToC (tI, objv[1], (void *)V, nP, 0, 'D') == 0) {
      free (memPtr);
      return TCL_OK;
   }
 
/* CALL the C routine                                                    */

  rV = MxEntCCmd_C (V, nP, C, nC );

/* DATA ARRAY back to Tcl                                                */

  CArrayToTcl (tI, objv[4], C, nC, 0, 'D');
                                                                                
/* Get rid of the temporary array and return                             */
                                                                                
   free (memPtr);

/* Return the mean square error                                          */

   objPtr = Tcl_GetObjResult(tI);
   Tcl_SetDoubleObj (objPtr, rV);
   return TCL_OK;
}

                                                                                
/* THE C ROUTINE                                                         */
                                                                                
                                                                                
ReaL_8 MxEntCCmd_C(ReaL_8 *V, int nP, ReaL_8 *C, int nC)
{
   void *memPtr = NULL;
   ReaL_8 *T1, *T2, *T3;
   ReaL_8 SuM, NuM, DeNoM, rV;
   ByTe_4 I, J, K;
   ByTe_4 Bytes, LastC, EnD;

   LastC = nC - 1;

   Bytes = sizeof(ReaL_8) * (2 * nP + nC);
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }
   T1 = (ReaL_8 *)memPtr;
   T2 = (ReaL_8 *)memPtr + nP;
   T3 = (ReaL_8 *)memPtr + 2 * nP;

   SuM = 0.0;
   for (I = 0;  I < nP; ++I) { SuM += V[I] * V[I]; }
   rV = SuM/(ReaL_8)nP;

   EnD = nP - 1;
   for (I = 0, J = 1;  I < EnD; ++I) { 
      T1[I] = V[I];
      T2[I] = V[J++];
   }

   for (I = 0;  I < nC; ++I) { 
      NuM = 0.0;
      DeNoM = 0.0;
      EnD = nP - I - 1;
      for (J = 0;  J < EnD; ++J) { 
         NuM += T1[J] * T2[J]; 
         DeNoM += T1[J] * T1[J] + T2[J] * T2[J]; 
      }
      C[I] = 2.0 * NuM / DeNoM;
      rV *= 1.0 - C[I] * C[I];

      K = I - 1;
      for (J = 0;  J < I; ++J) { C[J] = T3[J] - C[I] * T3[K--]; }

      if (I == LastC) { free(memPtr);  return(rV); }

      for (J = 0;  J <= I; ++J) { T3[J] = C[J]; }

      EnD = nP - I - 2;
      for (J = 0, K = 1;  J < EnD; ++J, ++K) { 
         T1[J] -= T3[I] * T2[J];
         T2[J] = T2[K] - T3[I] * T1[K];
      }
   }

   free(memPtr);
   return(-1);
}
