/*  The C equivalent of FfTConvolve,  It consists of a TCL interface over   */
/*  straight C subroutine                                                   */
/*                                                                          */
/*  There are 6 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Input Data array                                           */
/*     OBJV[2]:  Length of data array                                       */
/*     OBJV[3]:  Response Function                                          */
/*     OBJV[4]:  Length of response function                                */
/*     OBJV[5]:  Operations flag (CONVOLVE or DECONVOLVE)                   */
/*     OBJV[6]:  Output Data array                                          */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TfftAnsi.h"
#include "TutilAnsi.h"
                                                                                
int FfTConvolveCmd (ClientData cD, Tcl_Interp *tI, int objc, 
                                                        Tcl_Obj *CONST *objv)
{
   void *memPtr = NULL;
   ReaL_8 *iD, *rF, *oD;
   int nP, nR, Bytes;
   ByTe_4 rV; 
   ByTe_1 *oFlg, Dir;
                                                                                
/* Make sure that all the IO parameters are present */
                                                                                
   if (objc != 7 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: FfTConvolve iD nP rF nR oFlg oD ");
     return TCL_ERROR;
   }
                                                                                
/* Get the non-array inputs changing the operations flag from a string to a */
/*  numerical representation.                                               */
                                                                               
   Tcl_GetIntFromObj (tI, objv[2], &nP);
   Tcl_GetIntFromObj (tI, objv[4], &nR);
   oFlg = Tcl_GetStringFromObj(objv[5], (int *)0);
   Dir = (strcmp("CONVOLVE", oFlg) == 0) ? 1 : 0;
                                                                                
/*  MALLOC memory to hold the data array                                 */
                                                                                
   Bytes = 4 * sizeof(ReaL_8) * nP;
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }
   iD  = (ReaL_8 *)memPtr;
   rF  = (ReaL_8 *)iD + nP;
   oD  = (ReaL_8 *)rF + nP;
                                                                                
/*  TRANSFER input data array                                            */

   if (TclArrayToC (tI, objv[1], (void *)iD, nP, 0, 'D') == 0) {
      free (memPtr);
      return TCL_OK;
   }

/*  TRANSFER response function                                           */

   if (TclArrayToC (tI, objv[3], (void *)rF, nR, 0, 'D') == 0) {
      free (memPtr);
      return TCL_OK;
   }

/* CALL the C routine                                                    */

  rV = FfTConvolveCmd_C (iD, nP, rF, nR, Dir, oD);

/* TRANSFER output data array to Tcl                                     */

  CArrayToTcl (tI, objv[6], oD, 2 * nP, 0, 'D');
                                                                                
/* Get rid of the temporary array and return                             */
                                                                                
   free (memPtr);
   return TCL_OK;
}

/* THE C ROUTINE                                                         */
                                                                                
                                                                                
ByTe_4 FfTConvolveCmd_C (ReaL_8 *iD, ByTe_4 nP, ReaL_8 *rF, ByTe_4 nR, 
                                     ByTe_1 Dir, ReaL_8 *oD)
{
   void   *memPtr = NULL;
   ReaL_8 *TmP;
   ReaL_8 hP, T, MaG;
   ByTe_4 I, J, K, BeG, EnD;
   ByTe_4 Bytes;

   Bytes = 4 * sizeof(ReaL_8) * nP;
   if ((memPtr = malloc (Bytes)) == NULL) { return -1; }
   TmP = (ReaL_8 *)memPtr;

   EnD = (nR -1)/2; 

   for ( I = 0;  I < EnD; ++I ) {
      J = nP - 1 - I;
      K = nR - 1 - I;
      rF[J] = rF[K];
   }

   EnD = nP - EnD;
   BeG = (nR + 3)/2  - 1; 
   for ( I = BeG;  I < EnD; ++I ) { rF[I] = 0.0; }

   TwoFfTCmd_C(iD, rF, TmP, oD, nP);
   
   hP = (ReaL_8)(nP >> 1);
   EnD = nP + 2; 
   if ( Dir == 1 ) {
     for ( I = 0, J = 1;   I < EnD; I += 2, J += 2 ) { 
        T = oD[I];
        oD[I] = (TmP[I] * T - TmP[J] * oD[J]) / hP;
        oD[J] = (TmP[J] * T + TmP[I] * oD[J]) / hP;
     }
   } else {
     for ( I = 0, J = 1;   I < EnD; I += 2, J += 2 ) { 
        MaG = hP * (oD[I] * oD[I] - oD[J] * oD[J]);
        if ( MaG == 0.0 ) { 
           fprintf(stderr, "ZERO RESPONSE IN FfTConvolve\n");
           return (-1);
        }
        T = oD[I];
        oD[I] = (TmP[I] * T - TmP[J] * oD[J]) / MaG;
        oD[J] = (TmP[J] * T + TmP[I] * oD[J]) / MaG;
     }
   }
   
   oD[1] = oD[nP];

   RealFfTCmd_C(oD, nP, -1);

   free (memPtr);

   return (1);
}
