package provide UDFAnalysis 1.0

proc APsolveXCal { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : CROSS CALIBRATION"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {

# GET the function variables

      set LiNe [$W get $I]
      scan $LiNe "%s %s %s %s %s %s %s" _dI _dO _dF _sM _aM _bO _vM

# GET the input and output variables.  Needs to be the same number or we
#   skip this definition

      set iNames [lindex [APgetVNames $_dI] 0]
      set nI [llength $iNames]

      set oNames [lindex [APgetVNames $_dO] 0]
      set nO [llength $oNames]

      if { $nI != $nO } { continue }

# ALL arrays are (or are supposed to be) the same length so get that now.  Also
#   get the grid information if it exists so that we don't include any bad data
#   in the averages.

      set vR [lindex $iNames 0]
      global [set vR ] ; upvar 0 [set vR] _Ti
      set nE [lindex $_Ti(Dim) 0]

      if [info exist _Ti(gInE)] { 
	 set OmiT $_Ti(gI11)
      } else { set OmiT $apANS(BaD) }

# SET up some option definitions so that we are not doing string compares
#   all over the place

      set ScA [string match Scalar $_dF]
      set CmP [string match Comp   $_vM]
      set AvG [string match Avg    $_sM]
      set AlM [string match Add    $_aM]

# WHEN aligning the vector quantities using the magnitude then you must
#   multiplicatively align.  Force that here

      if { !$ScA && !$CmP} { set AlM 0 }

# SET up the proper math operators to do the cross calibration according
#   to the alignment method selected.

      if $AlM { 
         set xcMoP + ; set sFMoP - 
      } else { set xcMoP * ; set sFMoP / }

# BASE offsets are used when calibrating against a particular mean value.
#   Vectors which calibrate against each component can have three. There
#   is one in all other cases.  Lets set three values in all cases so that
#   we don't need to worry how many we need

      set bOff(0) 0 ; set bOff(1) 0 ; set bOff(2) 0
      if { !$AvG } {
         set tMp [split $_bO ","] 
         if { !$ScA && $CmP} {
            set tMp [split $_bO ","] 
            set bOff(0) [expr 3 * [lindex $tMp 0]]
            set bOff(1) [expr 3 * [lindex $tMp 1] + 1] 
            set bOff(2) [expr 3 * [lindex $tMp 2] + 2] 
         } else { 
            if { !$ScA } {
	        set bOff(0) [expr 3 * [lindex $tMp 0]] 
	    } else { set bOff(0) [lindex $tMp 0] } 
         }
      }

# SET up a few constants that we will use later.  These include:
#   nC: This is 3 for vector inputs and 1 for scalar
#   tC: This is the total number of individual input definitions

      if $ScA {
         set tC $nI ; set nC 1
      } else { set tC [expr $nI / 3] ; set nC 3 }

# GET the mean values of all the entry data up front. This needs to be split 
#   as with vectors we may need just the mean of the magnitudes and not of
#   all components.  Make sure that we get one mV for each input definition.
#   For vectors which use the magnitude for scaling just duplicate this 
#   value per component.

      if { !$ScA && !$CmP } {
         for { set J 0 ; set K 0 } { $J < $nI } { } {
            set vR [lindex $iNames $J] ; incr J
            global [set vR ] ; upvar 0 [set vR] _X
            set vR [lindex $iNames $J] ; incr J
            global [set vR ] ; upvar 0 [set vR] _Y
            set vR [lindex $iNames $J] ; incr J
            global [set vR ] ; upvar 0 [set vR] _Z

            set meanV 0.0
	    set mC 0
            for { set L 0 } { $L <  $nE } { incr L } {
               if { ($_X($L) > $OmiT) && ($_Y($L) > $OmiT) && ($_Z($L) > $OmiT) } {
                  set meanV [expr $meanV + sqrt( $_X($L) * $_X($L) + \
                                   $_Y($L) * $_Y($L) + $_Z($L) * $_Z($L))]
                  incr mC
               }
            }
	    if { $mC > 0 } {
               set mV($K) [expr $meanV / double($mC)] ; incr K
               set mV($K) [expr $meanV / double($mC)] ; incr K
               set mV($K) [expr $meanV / double($mC)] ; incr K
            } else {
               if $AlM { set meanV 0.0 } else { set meanV 1.0 }
               set mV($K) $meanV ; incr K
               set mV($K) $meanV ; incr K
               set mV($K) $meanV ; incr K
	    }
	 }
      } else {
         for { set J 0  } { $J < $nI } { incr J } {
            set vR [lindex $iNames $J]
            global [set vR ] ; upvar 0 [set vR] _Ti

            set mV($J) 0.0
	    set mC 0
            for { set K 0 } { $K <  $nE } { incr K } {
               if { $_Ti($K) > $OmiT } {
	          set mV($J) [expr $mV($J) + $_Ti($K)]
		  incr mC
               }
            }
	    if { $mC > 0 } {
               set mV($J) [expr $mV($J) / double($mC)]
            } else { if $AlM { set mV($J) 0.0 } else { set mV($J) 1.0 } }
         }
      }

# NOW determine the scaling factor to use for each component.  This is
#   different for calibrating against the overall mean and the mean of
#   of an element. It is also different if we are aligning the values
#   by and additive or multiplicative shift.

      if $AvG {
         for { set J 0 } { $J < $nC } { incr J } {
	    set tV 0.0
            for { set K $J } { $K < $nI } { incr K $nC } {
	          set tV [expr $mV($K) + $tV] 
            }
	    set bV($J) [expr $tV /double($tC)]
         }
      } else { 
         for { set J 0 } { $J < $nC } { incr J } { set bV($J) $mV($bOff($J)) }
      }

      for { set J 0 } { $J < $nC } { incr J } {
         for { set K $J } { $K < $nI } { incr K $nC } {
            set _sF($K) [expr $bV($J) $sFMoP $mV($K)]
         }
      }

# RESCALE the input variables

      for { set J 0  } { $J < $nI } { incr J } {
         set vR [lindex $iNames $J]
         global [set vR ] ; upvar 0 [set vR] _Ti

         set vR [lindex $oNames $J]
         global [set vR ] ; upvar 0 [set vR] _To

         set _To(Dim) [list $nE 1]
	 APxferGInfo _Ti _To

         for { set K 0 } { $K <  $nE } { incr K } {
            set _To($K) [expr $_sF($J) $xcMoP $_Ti($K)]
         }
      }
   }
}
