package provide UDFAnalysisTh 1.0

# Computes the surface and/or volume of various shapes.

proc APsolveSurfVol { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : SURF-VOL"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# SET up the threading variable which defines the procedures that the
#    threads know about.

   set PgmA {
      source [ file join $env(TCLTOOLS_HOME) TclToolInits.tcl ]
      TclToolInits THREAD UTILS

      proc CirCle { rN } {
         global PI 

	 set bG [expr $rN * [tsv::get surVol bS]]
	 set eN [expr ($rN + 1) * [tsv::get surVol bS]]
	 set nE [tsv::get surVol nE]
	 if { $eN > $nE } { set eN $nE }

         for { set J $bG } { $J < $eN } { incr J } {
            tsv::set _OutS $J [expr $PI * [tsv::get _R $J] * [tsv::get _R $J]]
	 }
      }

      proc SphEre { rN } {
         global PI 

	 set bG [expr $rN * [tsv::get surVol bS]]
	 set eN [expr ($rN + 1) * [tsv::get surVol bS]]
	 set nE [tsv::get surVol nE]
	 if { $eN > $nE } { set eN $nE }

         if [tsv::get surVol DoS] {
	    set _F1 [expr 4.0 * $PI]
            for { set J $bG } { $J < $eN } { incr J } {
               set _R2 [expr [tsv::get _R $J] * [tsv::get _R $J]]
	       tsv::set _OutS $J [expr $_F1 * $_R2]
            }
         }

         if [tsv::get surVol DoV] {
	    set _F1 [expr 4.0 * $PI / 3.0]
            for { set J $bG } { $J < $eN } { incr J } {
               set _R2 [expr [tsv::get _R $J] * [tsv::get _R $J]]
	       tsv::set _OutV $J [expr $_F1 * $_R2 * [tsv::get _R $J]]
            }
         }
      }

      proc TetraHedron { rN } {

# AREA is computed from Heron's formula for individual triangles.   
#   Volume is computed from:
#
#                 | 0     1      1       1       1    |
#                 | 1     0    d01**2  d02**2  d03**2 |
#      288V**2 =  | 1  d01**2     0    d12**2  d13**2 |
#                 | 1  d02**2  d12**2    0     d23**2 |
#                 | 1  d03**2  d13**2  d23**2    0    |
#
# where dij is the distance between the ij vertices

# CAN set the top row and diagonal elements of both matrices

         for { set K 0 } { $K < 16 } { incr K 5 } { set A($K) 0.0 } 
         for { set K 1 } { $K < 4 } { incr K } { set A($K) 1.0 } 

         for { set K 0 } { $K < 25 } { incr K 6 } { set V($K) 0.0 } 
         for { set K 1 } { $K < 5 } { incr K } { set V($K) 1.0 } 

# SINCE we have to compute the edge lengths for both surface and volume
#   area do that in the loop only once.  The computations of both are
#   within if checks in the loop.

	 set bG [expr $rN * [tsv::get surVol bS]]
	 set eN [expr ($rN + 1) * [tsv::get surVol bS]]
	 set nE [tsv::get surVol nE]
	 if { $eN > $nE } { set eN $nE }

         for { set J $bG } { $J < $eN } { incr J } {

            set SuM 0.0
            for { set K 0 } { $K < 3 } { incr K } { 
	       set Sa [expr 4 * $J + $K]
               for { set L [expr $K + 1] } { $L < 4 } { incr L } { 
	          set Sb [expr 4 * $J + $L]
		  set dX [expr [tsv::get _X $Sa] - [tsv::get _X $Sb]]
		  set dY [expr [tsv::get _Y $Sa] - [tsv::get _Y $Sb]]
		  set dZ [expr [tsv::get _Z $Sa] - [tsv::get _Z $Sb]]
	          set S($K,$L) [expr $dX * $dX + $dY * $dY + $dZ * $dZ]
	          set S($L,$K) $S($K,$L)
	       }
            }

	    if [tsv::get surVol DoS] {
               set iList [list 6 7 11]
               set sList [list 0,1 0,2 1,2 0,2 0,3 2,3 0,1 0,3 1,3 \
		               1,2 1,3 2,3 ]

               set vC 0
               for { set K 0 } { $K < 4 } { incr K } {
                  for { set L 0 } { $L < 3 } { incr L ; incr vC } {
	          set A([lindex $iList $L]) $S([lindex $sList $vC])  
               }

               set BeG 1
               for { set M 4 } { $M < 16 } { incr M 5 } { 
	          set N $BeG
                  for { set L $M } { $L < 16 } { incr L 4 ; incr N } { 
	              set A($L) $A($N)
                   }
	           incr BeG 5
               }

               set D [TUmatrixDet A 4]
               if { $D < 0.0 } { set D [expr -1 * $D]}
                  set SuM  [expr $SuM + sqrt($D / 16.0)]
               }
               tsv::set _OutS $J $SuM
	    }

	    if [tsv::get surVol DoV] {
	       set V(7) $S(0,1) ; set V(8) $S(0,2) ; set V(9) $S(0,3)
	       set V(13) $S(1,2) ; set V(14) $S(1,3) ; set V(19) $S(2,3)

               set BeG 1
               for { set K 5 } { $K < 25 } { incr K 6 } { 
                  set N $BeG
                  for { set L $K } { $L < 25 } { incr L 5 ; incr N } { 
	             set V($L) $V($N)
                  }
	          incr BeG 6
               }

               set D [TUmatrixDet V 5]
               if { $D < 0.0 } { set D [expr -1 * $A]}
               tsv::set _OutV $J [expr sqrt($D / 288.0)]
	    }
	 }
      }

      proc TriAngle { rN } {

# AREA is computed usng determinent form of Heron's formula.  If a, b,
#   and c are the lengths of the three sides of the triangle then the
#   volume is
#
#                 | 0     1      1       1     |
#                 | 1     0    d01**2  d02**2  |
#      -16V**2 =  | 1  d01**2     0    d12**2  |
#                 | 1  d02**2  d12**2    0     |

# CAN set the top row and diagonal elements 

         for { set K 0 } { $K < 16 } { incr K 5 } { set A($K) 0.0 } 
         for { set K 1 } { $K < 4 } { incr K } { set A($K) 1.0 } 

	 set bG [expr $rN * [tsv::get surVol bS]]
	 set eN [expr ($rN + 1) * [tsv::get surVol bS]]
	 set nE [tsv::get surVol nE]
	 if { $eN > $nE } { set eN $nE }

         for { set J $bG } { $J < $eN } { incr J } {

            for { set K 0 } { $K < 2 } { incr K } { 
	       set Sa [expr 3 * $J + $K]
               for { set L [expr $K + 1] } { $L < 3 } { incr L } { 
	          set Sb [expr 3 * $J + $L]
		  set dX [expr [tsv::get _X $Sa] - [tsv::get _X $Sb]]
		  set dY [expr [tsv::get _Y $Sa] - [tsv::get _Y $Sb]]
		  set dZ [expr [tsv::get _Z $Sa] - [tsv::get _Z $Sb]]
	          set S($K,$L) [expr $dX * $dX + $dY * $dY + $dZ * $dZ]
	       }
            }

            set A(6) $S(0,1) ; set A(7) $S(0,2) ; set A(11) $S(1,2)

# REST of matrix elements are set by transposing the data thats there.

            set BeG 1
            for { set K 4 } { $K < 16 } { incr K 5 } { 
	       set N $BeG
               for { set L $K } { $L < 16 } { incr L 4 ; incr N } { 
	          set A($L) $A($N)
               }
	       incr BeG 5
            }

# SOLVE for the area

            set D [TUmatrixDet A 4]
            if { $D < 0.0 } { set D [expr -1 * $A]}
            tsv::set _OutS $J [expr sqrt($D / 16.0)
         }
      }
   }   

# XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
# START here 
# XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s" _In _Geo _Mea _OuT

      set DoS 0 ; set DoV 0  
      if [string match "Both" $_Mea] {
         set DoS 1 ; set DoV 1  
      } elseif [string match "Volume" $_Mea] { set DoV 1 } else { set DoS 1 }

# MAKE the surface and volume do flags available to the thread

      tsv::set surVol DoV $DoV
      tsv::set surVol DoS $DoS

# GET the input vertice or radii list

      set vNames [lindex [APgetVNames $_In] 0]
      set npV [llength $vNames]

# GET the output variable list

      set oNames [lindex [APgetVNames $_OuT] 0]
      set nO [llength $vNames]

# SET up the output variables.  _Oa is surface and _Ob is volume.  If both
#   are returned the surface is always the first of the pair

      set Elem 0
      if $DoS {
         set vR [lindex $oNames $Elem]
         global [set vR] ; upvar 0 [set vR] _Oa
         incr Elem
      }
      if $DoV {
         set vR [lindex $oNames $Elem]
         global [set vR] ; upvar 0 [set vR] _Ob
      }

# CAN use the spatial-derivative unpacking to separate variables.  Set up
#   the geometry dependent input parameters here

      switch -exact -- $_Geo {
         Circle -    
         Sphere { 
            set Type S
            set tnV  1
	 }
         Triangle { 
	    set Type V
            set tnV  3
	 }
         Tetrahedron { 
	    set Type V
            set tnV  4
	 }
      }

# REMEMBER APsdVar releases iNFO !!!
 
      if [string match "V" $Type] { 
         APsdVar X $tnV $vNames _X YES
         APsdVar Y $tnV $vNames _Y YES
         APsdVar Z $tnV $vNames _Z YES
      } else { APsdVar S $tnV $vNames _R YES }

      set nE [lindex $_X(Dim) 0]
      set bS [expr int(ceil($nE / double($apANS(MaxThreads))))]
      if { $bS <= 100 } { 
         set bS 100 
         set nB [expr int(ceil($nE / double($bS)))]
      } else { set nB [expr int(ceil($nE / double($bS)))] }

# MAKE the number of elements in the array, the block size, and the number of
#    blocks available to the thread
 
      tsv::set surVol nE $nE
      tsv::set surVol bS $bS
      tsv::set surVol nB $nB

      set jB []
      set tPoolID [THpoolOpen "$PgmA"]

      switch -exact -- $_Geo {
         Circle {    
	    for { set J 0 } { $J < $nB } { incr J } {
	       lappend jB [THschdTask $tPoolID [list CirCle $J]]
            }
         }
         Sphere {    
	    for { set J 0 } { $J < $nB } { incr J } {
	       lappend jB [THschdTask $tPoolID [list SphEre $J]]
            }
         }
         Triangle {    
	    for { set J 0 } { $J < $nB } { incr J } {
	       lappend jB [THschdTask $tPoolID [list TriAngle $J]]
            }
	 }
         Tetrahedron {    
	    for { set J 0 } { $J < $nB } { incr J } {
	       lappend jB [THschdTask $tPoolID [list TetraHedron $J]]
            }
         }
      }
      THjobsDone $tPoolID $jB
      THpoolClose $tPoolID

      if $DoS {
         THarrayXfer FROM _Oa _OutS YES
         set _Oa(Dim) [list $nE 1]
         APxferGInfo _X _Oa
      }
      if $DoV {
         THarrayXfer FROM _Ob _OutV YES
         set _Ob(Dim) [list $nE 1]
         APxferGInfo _X _Ob
      }

      tsv::unset _X
      tsv::unset _Y
      tsv::unset _Z
      tsv::unset surVol
   }
}
