package provide UDFAnalysis 1.0

# THE way this module is setup makes processing it a bit of a pain.  The
#   first definition must have the variable name being filled.  Succeeding 
#   lines with a blank variable name have their entries tied to this variable

proc APsolveSetv { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : SETV"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances to see how to group definitions

   set Starts ""
   for { set I 0 } { $I < $nF } { incr I } {
      set LiNe [$W get $I]
      scan $LiNe "%s %s %s %s %s %s" _vO _vP _V(0) _V(1) _V(2) _V(3)
      if ![string match "---"  $_vO] { lappend Starts $I }
   }

# LOOP over the groups

   set nS [expr [llength $Starts] - 1 ]
   for { set G 0 } { $G <= $nS } { incr G } {

      if { $G != $nS } {
         set EnD [lindex $Starts [expr $G + 1]]
      } else { set EnD $nF }
      set BeG [lindex $Starts $G]

      for { set I $BeG } { $I < $EnD } { incr I } {

# GET the first line
   
         set LiNe [$W get $I]

# BREAK it apart

         scan $LiNe "%s %s %s %s %s %s" _vO _vP _V(0) _V(1) _V(2) _V(3)

# OPEN the output file if this first read for this block.  Need to
#    check and be able to set up for multiple variable definitions

         if { $I == $BeG } {
            set oNames [lindex [APgetVNames $_vO] 0]
	    set nO [llength $oNames]
         }

# What to do is determined by the request in _vP
#    ALL - fill all the variable elements with the specified constant or
#          variable value.  If a variable value is specified it must be a
#          scalar -- i.e. a specific element in the variable. Assumes single 
#          output variable.
#    COPY - copy the 1st specified input variables into the output variables
#           Must be a 1-1 correspondence between the input an out variables.
#    MERGE - Merge a set of scalar variables from a set of multi-variables 
#            into a single variable. Assumes single output variable.
#    num  - fill the output variable with the values found in the input
#           variables.  There is only output variable.  Input values can be
#           number values or scalars.  _vP is where to start filling the
#           output variable
 
         switch -exact -- $_vP {
	    ALL {
               APmakeGrid gI POINT

               set iNames [APgetVNames $_V(0)]
	       set vNames [lindex $iNames 0]
	       set bType  [lindex $iNames 1]
	       set vType  [lindex $bType 0]

	       if { $vType == 1 } { 
	          set _fV [lindex $vNames 0]
               } else {
		  set _vN [lindex $vNames 0]
	          set _oP [string first "(" $_vN]
	          set _cP [string first ")" $_vN]
		  set _Vn [string range $vN 0 [expr $_oP - 1]]
		  set _Vi [string range $vN $_oP end]
		  set Vr [lindex $iNames $L]
		  global [set Vr] ; upvar 0 [set Vr] _TmP
		  set _T \$$_Vr$_Vi
		  set _fV [expr $_T]
               }
	       
	       for { set J 0 } { $J < $nO } { incr J } { 
	          set vR [lindex $oNames $J]
	          global  [set vR] ; upvar 0 [set vR] _oV

	          for { set K 0 } { $K < $gI(4) } { incr K } { 
		     set _oV($K) $_fV
		  }
	          set _oV(Dim) [list $gI(4) 1]
	          APxferGInfo gI _oV GI REVERSE
               }
	    }

	    COPY {
               set iNames [APgetVNames $_V(0)]
	       if { [llength $iNames] != $nO } {
	          puts stderr "Input/Output variable number mismatch"
		  return
	       }

	       set vR [lindex $iNames 0]
	       global  [set vR] ; upvar 0 [set vR] _iV

	       if ![exists _iV(gInE)] { 
	         puts stderr "No gird information in variable $vR"
		 return 
	       } else { APxferGInfo _iV gI } 
	       
	       for { set J 0 } { $J < $nO } { incr J } { 
	          set vR [lindex $iNames $J]
	          global  [set vR] ; upvar 0 [set vR] _iV
	          set vR [lindex $oNames $J]
	          global  [set vR] ; upvar 0 [set vR] _oV

	          for { set K 0 } { $K < $gI(4) } { incr K } { 
		     set _oV($K) $_iV($K)
		  }
	          set _oV(Dim) [list $gI(4) 1]
	          APxferGInfo gI _oV DATA REVERSE
               }
	    }

	    SPLIT {

	       set _oP [string first "(" $_V(0)]
	       set _cP [string first ")" $_V(0)]
	       set _Vn [string range $_V(0) 0 [expr $_oP - 1]]
	       set _Vi [string range $_V(0) $_oP end]
               set iNames [lindex [APgetVNames $_Vn] 0]
	       set nI [llength $iNames]

	       if {$nI != $nO } {
	          puts stderr "Input/Output variable number mismatch"
		  return
               }

	       for { set K 0 } { $K < $nI } { incr K } { 
	          set vO [lindex $oNames $K]
	          global  [set vO] ; upvar 0 [set vO] _oV

	          set vI [lindex $iNames $K]
	          global  [set vI] ; upvar 0 [set vI] _TmP

	          set _T \$$vI$_Vi
	          set _oV(0) [expr $_T]
	          set _oV(Dim) [list 1 1]
               }
	    }

	    MERGE {
	       set vR [lindex $oNames 0]
	       global  [set vR] ; upvar 0 [set vR] _oV

	       set _oP [string first "(" $_V(0)]
	       set _cP [string first ")" $_V(0)]
	       set _Vn [string range $_V(0) 0 [expr $_oP - 1]]
	       set _Vi [string range $_V(0) $_oP end]
               set iNames [lindex [APgetVNames $_Vn] 0]
	       set nI [llength $iNames]

	       set _N 0
	       for { set K 0 } { $K < $nI } { incr K } { 
	          set vR [lindex $iNames $K]
	          global  [set vR] ; upvar 0 [set vR] _TmP

	          set _T \$$vR$_Vi
	          set _oV($_N) [expr $_T]
		  incr _N
               }
               set _oV(Dim) [list $_N 1]
	    }

	    default {
	       set vR [lindex $oNames 0]
	       global  [set vR] ; upvar 0 [set vR] _oV
               if ![string match "---"  $_vP] { set _N  $_vP }

	       for { set K 0 } { $K < 4 } { incr K } { 
                  if ![string match "---"  $_V($K)] { 
                     set rV [APgetVNames $_V($K)]
	             set vNames [lindex $rV 0]
	             set bType  [lindex $rV 1]
	             set vType  [lindex $bType 0]
		     if { $vType == 1 } { 
		        set _oV($_N) $_V($K) 
		        incr _N 
                     } else {
	                set _oP [string first "(" $_V($K)]
	                set _cP [string first ")" $_V($K)]
	                set _Vn [string range $_V($K) 0 [expr $_oP - 1]]
	                set _Vi [string range $_V($K) $_oP end]
                        set iNames [lindex [APgetVNames $_Vn] 0]
	                set vR [lindex $iNames 0]
	                global  [set vR] ; upvar 0 [set vR] _TmP

	                set _T \$$vR$_Vi
	                set _oV($_N) [expr $_T]
		        incr _N
                     }
                  }
               }
               set _oV(Dim) [list $_N 1]
            }
         }
      }
   }
}
