package provide UDFAnalysisTh 1.0

# THIS procedure removes spikes from a GRIDDED data set. The data set is
#   split into a number of intervals of nP points with the last interval
#   taking on all left over points. The standard deviation in each interval
#   is computed and all points larger than mSig are removed. There is 
#   one further iteration will all of the removed data excluded. The removed
#   data can be filled or not.
 

proc APsolveRmSpike { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : RMSPIKE"

# THIS is the text window for this function definition
 
   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS defines the procedure(s) recognized by the threads

   set PgmA {
      source [ file join $env(TCLTOOLS_HOME) TclToolInits.tcl ]
      TclToolInits THREAD UTILS FFT
      lappend auto_path [file join $env(TCLTOOLS_HOME) TclAnalysisTh]
      package require UDFAnalysis
      package require UDFAnalysisTh

# THIS procedure removes the spikes within one of the data intervals.  The
#   interval is determined from the run number and the beginning offset.
 
      proc DeSpike { rN bOff } {

# SET up some of the commonly used variables here.

         set _nP [tsv::get deSp _nP]
         set _nS [tsv::get deSp _nS]
         set _nE [tsv::get deSp _nE]

# COMPUTE the beginning and ending locations of the data interval
 
         set BeG [expr $rN * $_nP + $bOff] 
         set EnD [expr $BeG + $_nP]

# SEE if we are at the end of our rope. If the next data block extends
#   beyond the end of the data then set the end of this interval to the
#   end of data. DoOnce says we can extend this interval to accomodate
#   ignored data. (Keep the number of good points at nP.)  We only do this 
#   on the first iteration.
 
	 if { [expr $EnD + $_nP] >= $_nE } { 
	    set EnD $_nE 
	    set DoOnce 0
         } else { set DoOnce 1 }

# ITERATE over the interval until no points exist above bounds
 
	 set KnB 0
	 set GoOn 1
         while { $GoOn } {

# GET the interval of data being worked on

            set nD 0
	    if $DoOnce {
	       set  L $BeG
	       while { ($L < $_nE ) && ($nD < $_nP) } {
                  if { [tsv::get _sA $L] } {
 	             set _TmP($nD) [tsv::get _In $L]
                     incr nD
                  } 
	          incr L
               }
	       if { $L >= $_nE } { 
	          set EnD $_nE
               } else { set EnD [expr $L + 1] }
	       set DoOnce 0
            } else {
               for { set L $BeG } { $L <  $EnD } { incr L } {
                  if { $_sA($L) } {
 	             set _TmP($nD) [tsv::get _In $L]
                     incr nD
                  }
               }
            }

# FORM the stand variation of the points 
 
            set AvG [TUarrayMath _TmP AVG _TmP _TmP $nD]
	    set VaR [TUarrayMath _TmP VAR $AvG _TmP $nD]
	    set SiG [expr sqrt($VaR)]

# SET to bad any point above maximum sigma 
 
            set nB 0
            set dRm [expr [tsv::get deSp _mSig] * $SiG]
	    for { set L $BeG } { $L <  $EnD } { incr L } {
	       set dV [expr abs([tsv::get _In $L] - $AvG)]
	       if { $dV >= $dRm } { tsv::set _sA $L 0 ; incr nB }
	    }

            if { $nB != $KnB } { set KnB $nB } else { set GoOn 0 }
         }
      }
   }

#XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
#  THE program starts here
#XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
       
# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# OPEN up the thread pool

   set tPoolID [THpoolOpen $PgmA]

# LOOP over the number of definitions
 
   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line

      set LiNe [$W get $I]

# BREAK it apart
#    _vI   : the input variables(s)
#    _vO   : the input variables(s)
#    _vS   : the return status array(s) 
#              value 0 means data dropped
#              value 1 means data kept
#    _mSig : the maximim sigma deviation from the average
#    _nP   : number of points in interval
#    _nS   : number of points to step between interaction

      scan $LiNe "%s %s %s %s %s %s %s %s %s %s %s" \
                   _vI _vO _vS _mSig _nP _nS _iFmt _C _lT _gT _fI

# XFER needed into the tsv space for threads
 
      tsv::set deSp _nP $_nP 
      tsv::set deSp _nS $_nS 
      tsv::set deSp _mSig $_mSig 
 
# GET the input variable list

      set rV [APgetVNames $_vI]
      set iNames [lindex $rV 0]
      set nI [llength $iNames]

# CHECK to see if we have a Status Array available.  If not we will build
#   one later
 
      if ![string match $apANS(EmptyVar) $_vS] {
         set rV [APgetVNames $_vS]
         set sNames [lindex $rV 0]
         set nStat [llength $sNames]
      } else { set nStat 0 }

# GET the output variable list

      set rV [APgetVNames $_vO]
      set oNames [lindex $rV 0]
      set nO [llength $oNames]

# HOW many points in a processing interval and how many points to slide it
#    Slide is a minimum of one point
 
      if { $_nS <= 0 } { set _nS 1 }

# YOU can't slide by more points than in the analysis interval otherwise we
#   will have periodic gaps 
 
      if { $_nS > $_nP } { set _nS $_nP}

# IF the data interval is given in terms of time then we need to compute the
#   number of points it contains from the time
 
      if [string match TIME $_iFmt] {
         set _niP [expr int($_nP / $apANS(CellSz))]
         set _niS [expr int($_nS / $apANS(CellSz))]
      } else { set _niP $_nP ; set _niS $_nS }

# LOOP over the input variables
 
      for { set J 0 } { $J <  $nI } { incr J } {

         set vR [lindex $iNames $J]
	 global [set vR]
	 upvar 0 [set vR] _In
         set _nE [lindex $_In(Dim) 0]
         tsv::set deSp _nE $_nE 

# GET the grid info array.  There has to be one!
 
         if ![info exist _In(gInE)] {
	    puts stderr "APsolveRmSpk -- $vR is not a gridded variable"
	    exit
	 } else { APxferGInfo  _In gI DATA REVERSE }

# CHECK if Status array is to be returned and if so initialize it
 
         if { $nStat > 0 } {
            set vR [lindex $sNames $J]
	    global [set vR]
	    upvar 0 [set vR] _sA
	    APxferGInfo gI _sA GI
	    set _sA(Dim) $_In(Dim)
         }

# SET up mask to exclude all specified data

	 APbadGrid $_C $_nE _In _sA 0 $_lT $_gT

# PUSH the input and status arrays to tsv space so they can be accessed by
#     the thread.

         THarrayXfer TO _In _In 
         THarrayXfer TO _sA _sA 

# ESTABLISH the output variables
 
         set vR [lindex $oNames $J]
         global [set vR]
         upvar 0 [set vR] _Out
	 set _Out(Dim) $_In(Dim)
	 APxferGInfo gI _Out GI

# NUMBER of data intervals blocks within the data array
 
         set lB [expr $_nE / $_nP] 

# NUMBER of integral steps to nearest block boundary
 
         set GoOn 1
         set CnTr 1
         while { $GoOn } {
            set tnP [expr $CnTr * $_nP] 
            if { [expr $tnP % $_nS] == 0 } { 
               set lS [expr $tnP / $_nS]
	       set GoOn 0
	    } else { incr CnTr }
         }

# LOOP over the number of interval slides
 
         for { set K 0 } { $K < $lS } { incr K } { 

            set bOff [expr $K * $_nS]

            set JoBs ""

# LOOP over the number of intervals to process
 
            for { set L 0 } { $L < $lB } { incr L } { 
	       lappend JoBs [THschdTask $tPoolID [list DeSpike $L $bOff] ]
            }
            THjobsDone $tPoolID $JoBs
	 }

# TRANSFER the status array from tsv space back to main space. Delete it
#    from tsc space. Also free ip the input data put into tsv space
 
         THarrayXfer FROM _sA _sA YES
	 tsv::unset _In

# Mask out all the bad data and fill in the holes if needed
 
         for { set K 0 } { $K < $_nE } { incr K } { set _Out($K) $_In($K) }
         APbadGrid RESET $_nE _Out _sA 0 gI(11) 
         if { [string match YES $_fI] } { TUgridFill1D _Out gI X LI -1 1 }
      }
   }

   tsv::unset deSp
   THpoolClose $tPoolID
}
