# MATH operations
#
# MATH operations are of the form A op B = C.  Thats pretty straight forward.
#   To make it less straight forward you can have multiple A,and B variables
#   in a single definition.  The rules are:

#   In the basic operations (+, -, *, /)  you either have the same number of
#   A and B variables, 1 A value with multiple B values or 1 B value with
#   multiple A values.  You must have as many C variabled defines as the
#   maximum number of A or B values.
#  
# SOME NOTES
#
#  EXPAND, SUM, AVG do not allow for repetitions


package provide UDFAnalysis 1.0

proc APsolveMath { fD } {
   global apANS env Prefs

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {
       APkeepTabs "STEP $fD : MATH ($I)"

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s" _Va _Op _Vb _OuT

# GET the input A array variable list and setup first variable where applicable

      set rV  [APgetVNames $_Va]
      set aN  [lindex $rV 0]
      set aVT [lindex [lindex $rV 1] 0]
      set nA  [llength $aN]
      if !$aVT {
         set vR [lindex $aN 0] ; global  [set vR] ; upvar 0 [set vR] _A
         set lA [expr [lindex $_A(Dim) 0] * [lindex $_A(Dim) 1]]
      } else { set lA 1 }

# GET the input B array variable list and setup first variable where applicable

      if ![string match $apANS(EmptyVar) $_Vb] {
         set rV  [APgetVNames $_Vb]
         set bN  [lindex $rV 0]
         set bVT [lindex [lindex $rV 1] 0]
         set nB  [llength $bN]
         if !$bVT {
            set vR [lindex $bN 0] ; global  [set vR] ; upvar 0 [set vR] _B
	    if [info exists _B(Dim)] {
               set lB [expr [lindex $_B(Dim) 0] * [lindex $_B(Dim) 1]]
            } else { set lB 1 }
         }
      } else { set nB 0 ; set bVT -1 ; set lB 1}

# DETERMINE which if any variables are constants and indicate which are
#   and which arn't.  Eg: AV_BV  means both a and b are variables, AV_BC
#   means a is a variable but b is a constant, etc.
 
      if { ($aVT == 0) && ($bVT == 0) } {
         set vT AV_BV
      } elseif { ($aVT == 0) && ($bVT == 1) } {
         set vT AV_BC
      } elseif { ($aVT == 0) && ($bVT == -1) } {
         set vT AV
      } elseif { ($aVT == 1) && ($bVT == 0) } {
         set vT AC_BV
      } elseif { ($aVT == 1) && ($bVT == 1) } {
         set vT AC_BC
      } else { set vT AC }

# GET the output output array list

      set rV [APgetVNames $_OuT]
      set cN [lindex $rV 0]
      set nC [llength $cN]

# Max output array number
 
      set nMax $nA 
      if { $nB > $nMax } { set nMax $nB }
      if { $nC > $nMax } { set nMax $nC }

# DETERMINE the repitition factor.  If A has more elements in it than B then
#   B will be applied A multiple times. the length of B must be an integral 
#   factor of the length of A.  Anytime there is constant in the operation
#   the repetation factor is always 1.
 
      set Reps 1
      if [string match AV_BV $vT] {
         if  ![string match EXPAND $_Op]  {
            if { $lB >= 1 } {
               set Rem [expr $lA % $lB]
               if { $Rem != 0 } { 
                  puts stderr "Unmatched arrays. A size is $lA, B is $lB"
                  exit
               } else { set Reps [expr $lA / $lB] }
            }
         }
      }
 
# NOW do the operations. Remember, there there can be one input A array
#   and with multiple B input arrays and vice-versa.

      switch -exact -- $_Op {
         + -
         - -
         * -
         / {

# DO the basic arithmetic operations depending on the A and B inputs 
#    (variable-variable  constant-variable, variable-constant,  or
#    constant-constant.
 
	    switch -exact -- $vT {
	       AV_BV {

# BOTH A and B are variables

                  if { $nA > $nB } { set EnD $nA } else { set EnD $nB }
                  for { set _N 0 } { $_N < $EnD } { incr _N } {
	             set J [expr $_N % $nA]
	             set K [expr $_N % $nB]

# GET the variables
 
                     set vR [lindex $aN $J] 
		     global [set vR] ; upvar 0 [set vR] _A
                     set vR [lindex $bN $K]
                     global [set vR] ; upvar 0 [set vR] _B
                     set vR [lindex $cN $_N]
		     global [set vR] ; upvar 0 [set vR] _C

# GIVE the output variable the same dimensions as the input variable A. Set
#   up the status array as indicating all in C which are not valid because
#   either corresponding elements in A and/or B are bad.
 
                     set _C(Dim) $_A(Dim)
	             APxferGInfo _A _C
                     APbadGrid FLAG $lA _A StatusA
                     APbadGrid AFLAG $lA,$lB _B StatusA
		     
# PERFORM the operation 
 
		     set aBeg 0
		     for { set L 0 } { $L < $Reps } { incr L } {
                        TUarrayMath _A $_Op _B  _C $lB $aBeg 0 $aBeg
		        incr aBeg $lB
                     }

# SET the elements in C which are not valid to BAD
 
                     APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
                  }		     
               }
	       AV_BC {

# A is a variable but B is a constant.

                  for { set _N 0 } { $_N < $nA } { incr _N } {

# GET the variables and the constant value

                     set vR [lindex $aN $_N] 
		     global [set vR] ; upvar 0 [set vR] _A
                     set cV  [lindex $bN 0]
                     set vR [lindex $cN $_N]
		     global [set vR] ; upvar 0 [set vR] _C

# GIVE the output variable the same dimensions as the input variable A. Set
#   up the status array as indicating all in C which are not valid because
#   corresponding elements in A are bad.
 
                     set _C(Dim) $_A(Dim)
	             APxferGInfo _A _C
                     APbadGrid FLAG $lA _A StatusA

# PERFORM the operation 

                     TUarrayMath _A $_Op $cV _C $lA

# SET the elements in C which are not valid to BAD
 
                     APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
                  } 
	       }
	       AC_BV {

# A is a constant but B is a variable.
 
                  for { set _N 0 } { $_N < $nB } { incr _N } {

# GET the variables and the constant value
 
                     set cV  [lindex $aN 0]
                     set vR [lindex $bN $_N]
		     global [set vR] upvar 0 [set vR] _B
                     set vR [lindex $cN $_N]
		     global [set vR] ; upvar 0 [set vR] _C

# GIVE the output variable the same dimensions as the input variable B. Set
#   up the status array as indicating all in C which are not valid because
#   corresponding elements in B are bad.

                     set _C(Dim) $_B(Dim)
	             APxferGInfo _B _C
                     APbadGrid FLAG $lB _B StatusB

# PERFORM the operation 

                     for { set J 0 } { $J < $lB } { incr J } {
		        set _C($J) [expr $cV $_Op $_B($J)]
		     }

# SET the elements in C which are not valid to BAD

                     APbadGrid RESET $lB _C StatusB 0 $apANS(BaD)
                  } 
	       }
	       AC_BC {

# BOTH A and B are constants.
# SET up the output variable.
 
                  set vR [lindex $cN $_N] ; global [set vR]
                  upvar 0 [set vR] _C
                  set _C(Dim) [list 1 1]

# GET the constants
 
                  set cVa  [lindex $aN 0]
                  set cVb  [lindex $bN 0]

# PERFORM the opearation
 
		  set _C(0) [expr $cVa $_Op $cVb]
               }
            }
         }
         ABS { 

# GET the absolute value of A and output it in C

            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global [set vR] ; upvar 0 [set vR] _A
               set vR [lindex $cN $_N] ; global [set vR] ; upvar 0 [set vR] _C

               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          if { $_A($J) < 0.0 } {
	             set _C($J) [expr -$_A($J)]
	          } else { set _C($J) $_A($J) }
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
	 ACOS -
	 ASIN -
         ATAN  -
         ATAND -
         ASIND -
         ACOSD - 
	 COS   -
	 COSD  -
	 SIN   -
	 SIND  {
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global [set vR] ; upvar 0 [set vR] _A
               set vR [lindex $cN $_N] ; global [set vR] ; upvar 0 [set vR] _C

               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               TUarrayMath _A $_Op _A _C $lA
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         AVG - 
         SUM { 

# AVG and SUM produces the sum or average of individual elements in the 
#   input variables.  These are returned in output varaible which will have
#   the same dimensions as the input variables.  All input variables must
#   have the same length. There may or may not be a B variable present.
#
#   SET the A and C variables
 
            set vR [lindex $aN 0] ; global [set vR] ; upvar 0 [set vR] _A
            set vR [lindex $cN 0] ; global [set vR] ; upvar 0 [set vR] _C

# GIVE the output variable the same dimensions as the input variable A. Set
#   up the status array as indicating all in C which are not valid because
#   corresponding elements in A are bad.

            set _C(Dim) $_A(Dim)
	    APxferGInfo _A _C
            APbadGrid FLAG $lA _A StatusA

# COPY the first variable in A to the output variable
 
	    for { set J 0 } { $J < $lA } { incr J } { set _C($J) $_A($J) }

# ADD any remaining A variables to the output variable. Remember to update
#   the status flag according to the newly added variables.

            for { set J 1 } { $J < $nA } { incr J } {
               set vR [lindex $aN $J] ; global [set vR] ; upvar 0 [set vR] _A
               APbadGrid AFLAG $lA _A StatusA
               TUarrayMath _A + _C _C $lA
            }

# NOW do the same for any B variables

            for { set J 0 } { $J < $nB } { incr J } {
               set vR [lindex $bN $J] ; global [set vR] ; upvar 0 [set vR] _B
               APbadGrid AFLAG $lB _B StatusA
               TUarrayMath _B + _C _C $lA
            }

	    if [string match AVG $_Op] {
	       set nV [expr double($nA + $nB)]
               TUarrayMath _C / $nV _C $lA
	    }

            APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
         }
         DETREND { 
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
	       set AvG 0.0
	       set tE 0
               for { set J 0 } { $J < $lA } { incr J } {
	          if $StatusA($J) {
	             incr tE
		     set AvG [expr $AvG + $_A($J)]
	          }
	       }
	       if { $tE > 0 } { set AvG [expr $AvG / double($tE)] }

               TUarrayMath _A - $AvG _C $lA
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         SQRT { 
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          if { $_A($J) >= 0.0 } {
	             set _C($J) [expr sqrt($_A($J))]
	          } else { set _C($J) $apANS(BaD) }
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         LOG10 { 
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          if { $_A($J) >= 0.0 } {
	             set _C($J) [expr log10($_A($J))]
	          } else { set _C($J) $apANS(BaD) }
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         LOGE { 
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          if { $_A($J) >= 0.0 } {
	             set _C($J) [expr log($_A($J))]
	          } else { set _C($J) $apANS(BaD) }
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         EXP { 
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          set _C($J) [expr exp($_A($J))]
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
	 EXPAND {
	    set pN -1
            for { set _N 0 } { $_N < $nMax } { incr _N } {

	       set _iA [expr $_N % $nA]
	       set _iB [expr $_N % $nB]
	       set _iC [expr $_N % $nC]

               set vR [lindex $aN $_iA] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $bN $_iB] ; global  [set vR]
               upvar 0 [set vR] _B

               set vR [lindex $cN $_iC] ; global [set vR]
               upvar 0 [set vR] _C

               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
	       set nP [APexpandFit $pN _B _A Dum Dum _C 1]
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
	 }
         POW { 
            set fV  [lindex $bN 0]
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          set _C($J) [expr pow($fV, $_A($J))]
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         FMOD { 

# FMOD of an array.  The value to fmod do is in bN.  There should
#  only be a single constant value.

           set fV  [lindex $bN 0]

            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          set _C($J) [expr fmod($_A($J), $fV)]
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         NORM { 

# NEED to find the absolute maximum of all the input variables

            set NorM $apANS(BaD)
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

	       set rV [TUdataMxMn _A $lA <>]
	       set MiN $_A([lindex $rV 0])
	       if { $MiN < 0.0 } { set MiN [expr -$MiN] }
	       if { $MiN > $NorM } { set NorM $MiN }
	       set MaX $_A([lindex $rV 1])
	       if { $MaX < 0.0 } { set MaX [expr -$MaX] }
	       if { $MaX > $NorM } { set NorM $MaX }
            }

            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          set _C($J) [expr $_A($J) / $NorM ]
	       }
	       set _C(Norm) $NorM
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
	 }
         MNMX -
         MNMXLOG {
	    if [string match MXMNLOG $_Op] {
	       set BaDL 0.0
            } else { set BaDL $apANS(BaDL) }

            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global  [set vR]
               upvar 0 [set vR] _C

# Set up a temporary array of the input data
 
               for { set _M 0 } { $_M < $lA } { incr _M } {
	          set _TmP($_M) $_A($_M)
               }

               APbadGrid CANDF $lA _TmP StatusA 0 $apANS(BaD)
	       set rV [TUdataMxMn _TmP $lA <> $BaDL $apANS(BaDU)]
	       set _C(0) $_TmP([lindex $rV 0])
	       set _C(1) $_TmP([lindex $rV 1])
	       set _C(aType) MXMN
	       set _C(Dim) [list 2 0]
            }
	 }
         TOTALA -
         TOTALS { 

# SUMS all of the elements in each input variables area added together to
#   produce either the total sum or the average of the elements. This
#   constitutes the single element in the output variable. This operation
#   makes no use of variable B.
 
            set LBaD $apANS(BaDL)
            set UBaD $apANS(BaDU)

            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global [set vR] ; upvar 0 [set vR] _A
               set vR [lindex $cN $_N] ; global [set vR] ; upvar 0 [set vR] _C

               set _C(Dim) [list 1 1]

               set _C(0) 0.0
	       set nE 0

	       for { set K 0 } { $K < $lA } { incr K } { 
	          if { ($_A($K) > $LBaD) &&  ($_A($K) < $UBaD) } {
	             incr nE
		     set _C(0) [expr $_C(0) + $_A($K)] 
                  }
               }

               set _C(nE) $nE

	       if [string match TOTALA $_Op] {
	          if { $nE > 0 } {
	             set _C(0) [expr $_C(0) / double($nE)]
	          } else { set _C(0) 0.0 }
               }
            }
         }
      }
   }
}
