package provide UDFAnalysis 1.0

# Fills data grids

proc APsolveGFill { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : GRIDFILL"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# GROUP sets of definitions which use a common source.  There are two things
#   to check for.  If there is no grid information variable then the entry
#   is its own group.  If there is a gI entry and no Grid variable then this
#   entry will be added to the last entry with a defined grid.  Although its
#   not checked for, you cannot have a definition with an unspecified gI entry
#   in the middle of a group entry.

   set Starts ""
   set JustFill ""
   for { set I 0 } { $I < $nF } { incr I } {
      set LiNe [$W get $I]
      scan $LiNe "%s %s %s %s %s %s" _vI _gInfo _X _Y _Z _gF
      if [string match $apANS(EmptyVar) $_gInfo] { 
         lappend Starts $I 
      } elseif ![string match $apANS(EmptyVar) $_vI] { 
         lappend Starts $I
      }
   }

# LOOP over the groups

   set nS [expr [llength $Starts] - 1 ]
   for { set G 0 } { $G <= $nS } { incr G } {
      if { $G != $nS } {
         set EnD [lindex $Starts [expr $G + 1]]
      } else { set EnD $nF }
      incr EnD -1
      set BeG [lindex $Starts $G]

# DO some one time initializations for the group

      set LiNe [$W get $BeG]
      scan $LiNe "%s %s %s %s %s %s" _vI _gInfo _X _Y _Z _gF

      set gName [lindex [APgetVNames $_vI] 0]
      set nG [llength $gName]

      set _gFill $_gF

# IF this is a set of grid builds then do the building now

      if ![string match $apANS(EmptyVar) $_gInfo] { 
         for { set I $BeG } { $I <= $EnD } { incr I } {

# GET the first line and break it apart.
   
            set LiNe [$W get $I]
            scan $LiNe "%s %s %s %s %s %s" _vI _gInfo _X _Y _Z _gF

# THERE are several options which for a group are taken from the first
#   entry settings.  These include the fill option as well as the grid
#   information variable. Set those now.

	    if { $I == $BeG } {

               set gDef [lindex [APgetVNames $_gInfo] 0]
               set vR [lindex $gDef 0] 
	       global [set vR ] ; upvar 0 [set vR] _gI

# SINCE we will be changing the NEW:ADD:END grid information setting we 
#   probably should work with a temporary instance of the grid information
#   settings
  
               set J 0
	       while { [info exists _gI($J)] } {
	          set _gT($J) $_gI($J)
		  incr J
	       }

	       if { $I == $EnD } {
	          set _gT(10) NEW:ADD:END
               } else { set _gT(10) NEW:ADD }
            } elseif { $I == $EnD } {
	       set _gT(10) ADD:END
            } else { set _gT(10) ADD }

# GET the intensity names. Check that there is one intensity varaible
#   for each grid.  If not crash and burn.

            set vName [lindex [APgetVNames $_Z] 0] 
            if { $nG != [llength $vName] } {
               puts stderr "APsolveFGrid: Grid /intensity variable mismatch."
	       return
            }

# GET the X extent of the measurement.  If there is no defined X variable
#   then the input variable should be a gridded variable in which case we
#   will obtain X from its grid parameters.  If there is only 1 X variable
#   defined then the second is set to the first.

            set Names [lindex [APgetVNames $_X] 0]
            set nV [llength $Names]
            if { $nV == 0 } {
               set vR [lindex $vName 0] 
	       global [set vR ] ; upvar 0 [set vR] _tV
               if [info exists _tV(gInE)] {
	          APxferGInfo _tV _tgI DATA REVERSE
		  TUgridInfo 30 _tgI _TmP
		  set _J 1
		  for { set _I 0 } { $_I < $_tgI(4) } { incr _I ; incr _J } {
		      set _xMn($_I) $_TmP($_I)
		      set _xMx($_I) $_TmP($_J)
		   }
		   set nX0 $_tgI(4)
		   set nX1 1
                   set nX  [expr $nX0 * $nX1]
               } else {
                  puts stderr "APsolveFGrid: No X variable definition"
	          return
	       }
	    } else {
               set vR [lindex $Names 0] 
	       global [set vR ] ; upvar 0 [set vR] _xMn
	       set nX0 [lindex $_xMn(Dim) 0]
	       set nX1 [lindex $_xMn(Dim) 1]
               set nX  [expr $nX0 * $nX1]
               if { $nV > 1 } {
                  set vR [lindex $Names 0]
                  global [set vR ] ; upvar 0 [set vR] _xMx
               } else { upvar 0 _xMn _xMx }
            }

# GET the Y extent of the measurement.  There may not be one in which
#   case create an array of 1 and set it to 0.  If there is treat it
#   exactly like X

            set Names [lindex [APgetVNames $_Y] 0]
            set nV [llength $Names]
            if { $nV == 0 } {
               set _yMn(0) 0.0
               set _yMx(0) 0.0
               set nY0 1
               set nY  1
            } else {
               set vR [lindex $Names 0]
               global [set vR ] ; upvar 0 [set vR] _yMn
	       set nY0 [lindex $_yMn(Dim) 0]
	       set nY1 [lindex $_yMn(Dim) 1]
               set nY  [expr $nY0 * $nY1]
               if { $nV > 1 } {
                  set vR [lindex $Names 0]
                  global [set vR ] ; upvar 0 [set vR] _yMx
               } else { upvar 0 _yMn _yMx }
            }

# NOW construct the grid

            for { set J 0 } { $J < $nG } { incr J } {
               set vG [lindex $gName $J] 
	       global [set vG ] ; upvar 0 [set vG] _gV

               set vZ [lindex $vName $J]  
	       global [set vZ ] ; upvar 0 [set vZ] _gZ
	       set nZ0 [lindex $_gZ(Dim) 0]
	       set nZ1 [lindex $_gZ(Dim) 1]
               set nZ  [expr $nZ0 * $nZ1]

#              set sX [expr int($nZ / $nX)]
#              set sY [expr int($nZ / $nX)]
#              if { $nY == 1 } { 
#                 set sY -1 
#              } elseif { ($sY != 1 } { set sY [expr -$sY] }
               set sX [expr int($nZ / $nX)]
               set sY [expr int($nZ / $nY)]
               if { $sY != 1 } { set sY [expr -$nY0] }

               TUdataGrid $nZ $sX _xMn _xMx $sY _yMn _yMx _gZ _gV Norm _gT

# SET the output array size now

               set _gV(Dim) [list $_gT(4) $_gT(5)]
	       APxferGInfo _gI _gV GI
            }
         }
      } 

# NOW fill any holes in the grid

      if ![string match OFF $_gFill] { 
         for { set J 0 } { $J < $nG } { incr J } {
            set vG [lindex $gName $J] 
	    global [set vG ] ; upvar 0 [set vG] _gV

            if [info exists _gV(gInE)] {
	       APxferGInfo _gV gI DATA REVERSE

               switch -exact -- $_gFill {
	          X { TUgridFill1D _gV _gI X LI -1 1 Norm }
	          Y { TUgridFill1D _gV _gI Y LI -1 1 Norm }
	          XY {
	             TUgridFill1D _gV _gI X LI -1 1 Norm
	             TUgridFill1D _gV _gI Y LI -1 1 Norm 
	          }
	          YX {
	             TUgridFill1D _gV _gI Y LI -1 1 Norm
	             TUgridFill1D _gV _gI X LI -1 1 Norm 
	          }
                  default {}
               }
            }
         }
      }
   }
}
