# EQUATION operations
#
# EQUATION operations are of arbitrary form and are solved as stated.  You
#   can mix vector and scalar variables in the equation.  All variables must
#   have the same length. 
#
# Variables in the equation have _ preappended (eq _C or _vec,C). Each
#   must be space delimited unless it is the leading or ending term in 
#   the expression.   The output variable is given separate from the
#   expression being solved.

package provide UDFAnalysis 1.0

proc APsolveEq { fD } {
   global apANS env Prefs

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {
      APkeepTabs "STEP $fD : EQUATION ($I)"

# GET the first line and break it apart
   
      set LiNe [$W get $I]
      regexp {([^ ]*)\s*(.*)} "$LiNe" TmP _vO _eQ

# GET the output variable list

      set oNames [lindex [APgetVNames $_vO] 0]
      set nO [llength $oNames]

# THIS is the expression separated into a list with the elements broken
#   by whitespace. Each varaible then is a separate element in the list.

      set nE [llength $_eQ]

# FIND the first input variable which is not a single element of a variable
#   and get its array length.  The first variable is the first list element 
#   in the equation beginning with an _.  If none then the output variable
#   is an array of length 1.

      set aL 1
      for { set J 0 } { $J < $nE } { incr J } {
         set _eL [lindex $_eQ $J]
         set _uS [string index $_eL 0]
         if [string match _ $_uS] {
            set _V [string range $_eL 1 end]
	    set _oP [string first "(" $_eL]
	    set _cP [string first ")" $_eL]
	    if { ($_oP < 0) && ($_cP < 0) } { 
	       set vNames [lindex [APgetVNames $_V] 0]
               set iV [lindex $vNames 0] ; global [set iV] 
	       upvar 0 [set iV] _T
	       set aL [lindex $_T(Dim) 0]
	       APxferGInfo _T gI DATA REVERSE
	       break
            }
         }
      }

# THERE is one expression per output variable. Initialize them now.
#   Also initialize the Status arrays of which there is 1 per equation.

      for { set J 0 } { $J < $nO } { incr J } { 
          set _eXp($J) "" 
          APbadGrid INIT $aL DUMMY Status$J
      }

# FORM the equations into something that expr will be happy with

      for { set J 0 } { $J < $nE } { incr J } {
         set _eL [lindex $_eQ $J]

# DON'T process blanks

         if { [string length $_eL] == 0 } { continue }

# CHECK to see if this is a variable, if it is it gets added to the
#   expression preappended with $ and post appended with ($I) unless 
#   it already has the () designated.

         if [string match _ [string index $_eL 0]] {
	    set _oP [string first "(" $_eL]
	    if { $_oP >= 0 }  {
               set _Indx [string range $_eL $_oP end]
               set _V [string range $_eL 1 [expr $_oP - 1]]
	       set vNames [lindex [APgetVNames $_V] 0]
               set nV [llength $vNames]
	       for { set K 0 } { $K < $nO } { incr K } {
	          set iV [lindex $vNames [expr $K % $nV]]
	          global [set iV] ; upvar 0 [set iV] _T
                  append _eXp($K) \$$iV$_Indx
               }
            } else {
               set _V [string range $_eL 1 end]
	       set vNames [lindex [APgetVNames $_V] 0]
               set nV [llength $vNames]
	       set vN ""
               for { set K 0 } { $K < $nV } { incr K } {
	          set iV [lindex $vNames $K]
	          global [set iV] ; upvar 0 [set iV] _T
	          lappend vN $iV
                  APbadGrid AFLAG [lindex $_T(Dim) 0] _T Status$K
               }

               if { $nV == 1 } {
	          set tN [lindex $vN 0]
                  for { set K 1 } { $K < $nO } { incr K } { lappend vN $tN }
               }
	       for { set K 0 } { $K < $nO } { incr K } {
                  append _eXp($K) \$[lindex $vN $K](\$K)
               }
            }
         } else {
	    for { set K 0 } { $K < $nO } { incr K } {append _eXp($K) " $_eL "}
         }
      }

      for { set J 0 } { $J < $nO } { incr J } { 
         set vA [lindex $oNames $J] ; global [set vA] ; upvar 0 [set vA] _oV 
         set _oV(Dim) [list $aL 1]
         for { set K 0 } { $K < $aL } { incr K } { 
            set _oV($K) [expr $_eXp($J)] 
         }

	 if [info exists gI(0)] {
	    APxferGInfo gI _oV GI
	    APbadGrid RESET $aL _oV Status$J 0 $apANS(BaD)
         }
      }
   }
}
