# COORDINATE transformations.  
#    You can rotate data between two coordinate systems by supplying a 
#    rotation matrix or between several known coordinate systems particular 
#    to space physics applications.  The latter have a temporal dependence
#    and currently only work with gridded data.
#    
#    The inputs from the associated GUI provide:
#
#        (_vI) The input coordinate vectors
#        (_vO) The transformed coordinate vectors
#        (_rM) The rotation matrix if this is a custom transformation
#        (_iC) The coodinate system of the input data for a known rotation 
#        (_oC) The coodinate system to rotate the input data into
#
#    Both _iC and _oC are required if no _rM is defined.

package provide UDFAnalysis 1.0

proc APsolveCtran { fD } {
   global apANS env Prefs RtoD

   APkeepTabs "STEP $fD : COORDINATES"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the transformaton definitions

   for { set I 0 } { $I < $nF } { incr I } {

# GET the conversion definition
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s" _vI _iC _rM _vO _oC

# GET the input and output varaible(s)

      set iNames [lindex [APgetVNames $_vI] 0]
      set nI [llength $iNames]
      set oNames [lindex [APgetVNames $_vO] 0]
      set nO [llength $oNames]

# IF the number of input and output variables don't match and the number
#    of input or output variables isn't' 3 then skip this function definition.

      if { ($nI != $nO) && ($nI != 3) } { continue }

# LINK local variables to the input variables

      set vA [lindex $iNames 0]
      global  [set vA] ; upvar 0 [set vA] _Ix
      set vA [lindex $iNames 1]
      global  [set vA] ; upvar 0 [set vA] _Iy
      set vA [lindex $iNames 2]
      global  [set vA] ; upvar 0 [set vA] _Iz

# LINK local variables to the output variables

      set vA [lindex $oNames 0]
      global  [set vA] ; upvar 0 [set vA] _Ox
      set vA [lindex $oNames 1]
      global  [set vA] ; upvar 0 [set vA] _Oy
      set vA [lindex $oNames 2]
      global  [set vA] ; upvar 0 [set vA] _Oz

# DO the coordinate transformations according to whether there is or is
#    not a provided transformation matrix.  If there is use it otherwise 
#    we are tranferring from one known coordinate system to another.
#
# CHECK to see if there is a provided rotation matrix and if there is do the
#   rotations
 
       if ![string match $apANS(EmptyVar) $_rM] {
          set rNames [lindex [APgetVNames $_rM] 0]
          set vA [lindex $rNames 0]
          global  [set vA] ; upvar 0 [set vA] _RoT
	  set nE [lindex $_Ix(Dim) 0]

	  for { set K 0; } { $K < $nE } { incr K } {
	     set tI(0) $_Ix($K) ; set tI(1) $_Iy($K) ; set tI(2) $_Iz($K)
	     TUmatrixMath _RoT * tI tO 3 3 3 1 0 0 0
	     set _Ox($K) $tO(0) ; set _Oy($K) $tO(1) ; set _Oz($K) $tO(2)
	  }
       } else { 

# DO the known coordinate transformations
 
# GET the grid infor associated with it - each component should have been
#   build into the same type of grid so only need info for one of them

         APxferGInfo _Ix gI DATA REVERSE

# THIS the center times of each cell in the grid.  These are offset 
#   seconds from the user requested begin time.

         TUgridInfo 32 gI _Xc

# SET up the time list of the beginning time

         set ubT [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]

         for { set J 0 } { $J < $gI(4) } { incr J } { 
            set cT [TUtimeConv $ubT $_Xc($J) 2 apANS(tBase)]
	    set Yr [lindex $cT 0]
	    set Dy [lindex $cT 1]
	    set Ms [lindex $cT 2]

	    set _V1(0) $_Ix($J) ; set _V1(1) $_Iy($J) ; set _V1(2) $_Iz($J)
	    TUdataCT _V1 $_iC DuMMy _V2 $_oC 1 $Yr $Dy $Ms
	    set _Ox($J) $_V2(0) ; set _Oy($J) $_V2(1) ; set _Oz($J) $_V2(2)
         }
      }
     
# TRANSFER the dimensions and gridding info using the information associated
#    with in input X variables
 
      set _Ox(Dim) $_Ix(Dim)
      set _Oy(Dim) $_Iy(Dim)
      set _Oz(Dim) $_Iz(Dim)
      APxferGInfo _Ix _Ox
      APxferGInfo _Iy _Oy
      APxferGInfo _Iz _Oz
   }
}
