# THIS procedure reads the menu file to get all of the user set options

package provide UDFAnalysis 1.0

proc APreadMenu { } {
   global apANS GUIoptPri GUIoptAlts

   if [string match #0000FF [.apMENU.im cget -fg]] {
      puts stderr "INPUT MENU UNDEFINED: $apANS(miFile)"
      return
   }

   if [catch {open $apANS(miFile) r} fd] {
      puts stderr "UNABLE TO OPEN MENUFILE: $apANS(miFile)"
      return
   }

#  READ in the saved values.  Blocks or saved replies in the menu are
#     separated by BEGIN and END.  These can be ignored.

   while { [gets $fd line] > 0 } {
      set nW [lindex $line 0] 
      if [string match END $nW]   { continue }
      if [string match BEGIN $nW] { 
         set fN [lindex $line 1]
	 if { [lsearch $apANS(fPlugins) $fN] >= 0 } {
             set pI ${fN}[lindex $line 2],rd 
	     set apANS($pI) 1
         } elseif { [lsearch $apANS(gPlugins) $fN] >= 0 } {
             set pI ${fN}[lindex $line 2],rd 
	     set apANS($pI) 1
         }
         continue 
      }

      set Fields [split $line '|']
      set I [lindex $Fields 0]

      set apANS($I) [lindex $Fields 1]
   }

   close $fd

# FILL in the comment text box

   APfillCom
}
