package provide UDFAnalysis 1.0

proc APpscriptOut { } {
   global apANS GphInfo DevInfo

# IS a postscript file required?

   if !$apANS(DoPS) { return }

   APkeepTabs "CREATE POSTSCRIPT OUTPUT"

# DETERMINE a file name we can use to dump the postscript to

   set bFn _T_P_S_F_
   set tFn _T_P_S_F_

   set I 0
   while { [file exists $tFn] == 1 } {
      set tFn $bFn
      append tFn $I 
      incr I
   }

# DUMP the postscript

   update
   set sC Scr$GphInfo(CurScr)
   set sCr $DevInfo($sC).drw
   $sCr postscript -file $tFn

# MAKE sure there is a .ps at the end of the output file name. Remove it if
#   there is and re-add it later

   if [string match ".ps" [file extension $apANS(psFn)]] {
      set  rawFile [file rootname $apANS(psFn)]
   } else { set rawFile $apANS(psFn) }

# SEE if we can overwrite any existing poscript file

   if !$apANS(OvrWrPS) {
      set oFile $rawFile
      set I 0
      while { [file exists $oFile.ps] == 1 } {
         set oFile $rawFile
         append oFile _[format %04d $I]
         incr I
      }
   } else { set oFile $rawFile }

# RE-ADD the .ps extension

   append oFile .ps

# CONVERT the dingbat and symbol font characters to proper postscript
#   output

    set aList [list $tFn $oFile $apANS(IncH) $apANS(IncS) \
                    $apANS(IncD) $apANS(IncLw) ]
    GPUconvPS $aList

# REMOVE the temporary postscript file

     file delete -force $tFn
}
