package provide UDFAnalysis 1.0

# DEFINES the current set of function plugins

proc APplugIns { } {
   global apANS

   set apANS(fPlugins) [list SPATIAL-DERV BIN COLLAPSE COORDINATES \
                             CONVERSION CROSS-CAL CROSS-HELICITY CUT \
                             DEFGRID DYNAMIC-PS EQUATION FILTER \
                             FIT GRIDFILL INDEX \
			     MASK MATH MEM MVA \
			     PLASMA PRINT \
                             RANDOM RMSPIKE ROTATION \
	 		     SETV SPIN-PER STATISTICS SURF-VOL UNSET \
			     VECTOR VMAP WAVE-TELESCOPE]

   set apANS(gPlugins) [list ARROW BOX LINE CIRCLE]

   set sP12 "            "

   set apANS(ARROW) \
           [list AParrowGUI APsolveGArrow [list [list PiD "" ""] \
               [list X1 "" ""] [list X2 "" ""] \
               [list Y1 "" ""] [list Y2 "" ""] \
	       [list oColor #ffffff  work.gcol|0|C] \
	       [list oWidth 1 ""] \
	       [list oStyle SOLID  work.ostyle|PRI|O]] \
	       [list "%-4s %-20s %-20s %-10s %-10s %-8s %-5s %-11s"]]

   set apANS(BIN) \
           [list APbinGUI APsolveBin [list [list BinI "" ""] \
	       [list BinA "" ""] [list BinO "" ""] [list BinL "" ""] \
	       [list BinU "" ""] [list BinN 1 ""] \
	       [list NormB NO work.no|PRI|O]] \
	       [list "%-11s %-10s %-11s %-8s %-8s %-4s %-5s"] ]

   set apANS(BOX) \
           [list APboxGUI APsolveGBox [list [list PiD "" ""] \
               [list X1 "" ""] [list X2 "" ""] \
               [list Y1 "" ""] [list Y2 "" ""] \
	       [list oColor #ffffff  work.gcol|0|C] \
	       [list oFill YES  work.bf|PRI|T] \
	       [list oWidth 1 ""]] \
	       [list "%-4s %-20s %-20s %-10s %-10s %-8s %-5s %-5s"]]

   set apANS(CIRCLE) \
           [list APcircleGUI APsolveGCircle [list [list PiD "" ""] \
               [list Xc "" ""] [list Yc "" ""] \
               [list R "" ""] [list rAxis Y  work.ra|PRI|T] \
	       [list oColor #ffffff  work.gcol|0|C] \
	       [list oFill YES  work.bf|PRI|T] \
	       [list oWidth 1 ""]] \
	       [list "%-4s %-20s %-10s %-20s %-5s %-8s %-5s %-5s"]]

   set apANS(COLLAPSE) \
           [list APcollapseGUI APsolveCollapse [list [list gIn "" ""] \
	       [list vOut "" ""] [list gcDir Y work.dir|PRI|T] \
	       [list gcMin "" ""] [list gcMax "" ""] \
               [list gcFmt AVG work.fmt|PRI|T]] \
	       [list "%-11s %-11s %-4s %-10s %-10s %-4s"] ]

   set apANS(COORDINATES) \
           [list APctranGUI APsolveCtran [list [list CTIn "" ""] \
	       [list CTIncoor "" work.inc|PRI|O] \
               [list CTMat "" ""] \
               [list CTOut "" ""] \
	       [list CTOutcoor "" work.outc|PRI|O] ] \
	       [list "%-12s %-6s %-12s %-12s %-6s"] ]

   set apANS(CONVERSION) \
           [list APconvGUI APsolveConv [list [list CVin "" ""] \
	       [list ConV "" work.cop|PRI|O] \
	       [list CReV NO work.rev|PRI|T] \
	       [list CPeR NO work.per|PRI|T] \
	       [list CVout "" ""] ] \
	       [list "%-12s %-19s %-8s %-5s %-12s"] ]

   set apANS(CROSS-CAL) \
           [list APxcalGUI APsolveXCal [list [list dIn "" ""] \
	       [list dOut "" ""] [list dFmt Scalar work.df|PRI|T] \
	       [list xcMet Avg work.me|PRI|T] \
	       [list xcShift Add work.sh|PRI|T] [list xcBase "" ""] \
	       [list vMet Comp work.vm|PRI|T]] \
	       [list "%-12s %-12s %-8s %-8s %-7s %-10s %-5s"] ]

   set apANS(CROSS-HELICITY) \
           [list APxhGUI APsolveXH [list [list XHden "" ""] [list XHv "" ""] \
	       [list XHmf "" ""] [list XHpout "" ""] [list XHnout "" ""] \
	       [list XHout "" ""]]  \
	       [list "%-11s %-11s %-11s %-11s %-11s %-11s"] ]

   set apANS(CUT) \
           [list APcutGUI APsolveCut [list [list vIn "" ""] \
	       [list vOut "" ""] [list cDir Y work.dir|PRI|T] \
	       [list iMin "" ""] [list iMax "" ""] ] \
	       [list "%-11s %-11s %-4s %-10s %-10s"] ]

   set apANS(DEFGRID) \
           [list APdefgridGUI APsolveDGrid [list [list gName "" ""] \
	       [list XMin "" ""] [list XMax "" ""] [list XCells "" ""] \
	       [list XFmt POINT work.xfmt|PRI|T] \
	       [list XSca LINEAR work.xsca|PRI|T] \
	       [list XCyc NO work.xcyc|PRI|T] [list IMin "" ""] \
	       [list gIX "" ""] \
	       [list YMin "" ""] [list YMax "" ""] [list YCells "" ""] \
	       [list YFmt POINT work.yfmt|PRI|T] \
	       [list YSca LINEAR work.ysca|PRI|T] \
	       [list YCyc NO work.ycyc|PRI|T] [list IMax "" ""] \
	       [list gIY "" ""]]\
	       [list "%-11s %-10s %-10s %-6s %-6s %-7s %-5s %-10s %-11s" \
	             "            %-10s %-10s %-6s %-6s %-7s %-5s %-10s %-11s"]]

   set apANS(EQUATION) \
           [list APeqGUI APsolveEq [list [list EQvarO "" ""] \
	       [list Eq "" ""]] [list "%-12s %-s" ] ]

   set apANS(DYNAMIC-PS) \
           [list APdpsGUI APsolveDps [list [list iN "" ""] \
	       [list ouT "" ""] [list dpMet MEM work.met|PRI|T] \
	       [list Len "" ""] [list Adv "" ""] [list nCoef "" ""] \
	       [list stepsF "" ""] [list begF "" ""] [list endF "" ""] \
	       [list fSca LOG work.sca|PRI|T] ] \
	       [list "%-10s %-11s %-5s %-5s %-5s %-5s %-5s %-7s %-7s %-7s"]]

   set apANS(FILTER) \
           [list APfilterGUI APsolveFilter [list [list iV "" ""] \
	       [list oV "" ""] [list lEdge "" ""] [list uEdge "" ""] \
               [list sO 2 ""] [list dO 0 ""] [list fMsk YES work.fm|PRI|T] \
               [list Ret "" ""]] \
	       [list "%-11s %-11s %-8s %-8s %-2s %-2s %-4s %-3s"] ]

   set apANS(FIT) \
           [list APfitGUI APsolveFit [list [list fType YES work.fit|PRI|T] \
               [list fDim "1" ""] [list fXYZI "" ""] [list fSca "LLLL" ""] \
               [list fCoef "" ""] [list cPset "" ""] \
	       [list fFunc TUpolyFunc ""] [list fO "" ""] ] \
	       [list "%-4s %-4s %-9s %-4s %-4s %-9s %-15s %-9s"] ]

   set apANS(GRIDFILL) \
           [list APgfillGUI APsolveGFill [list [list gV "" ""] \
               [list gI "" ""] [list gX "" ""] [list gY "" ""] \
               [list gZ "" ""] [ list gF OFF "work.gf|PRI|O"] ] \
	       [list "%-11s %-11s %-12s %-12s %-11s %-6s"]] 

   set apANS(INDEX) \
           [list APindexGUI APsolveIndex [list [list SrcI "" ""] \
	       [list SrcO "" ""] [list Ret Center work.ret|PRI|O] \
	       [list BeG 0 ""] [list EnD 1 ""] [list nElem 1]] \
	       [list "%-12s %-12s %-12s %-10s %-10s %-5s"]]

   set apANS(LINE) \
           [list APlineGUI APsolveGLine [list [list PiD "" ""] \
               [list X1 "" ""] [list X2 "" ""] \
               [list Y1 "" ""] [list Y2 "" ""] \
	       [list oColor #ffffff  work.gcol|0|C] \
	       [list oWidth 1 ""] \
	       [list oStyle SOLID  work.ostyle|PRI|O]] \
	       [list "%-4s %-20s %-20s %-10s %-10s %-8s %-5s %-11s"]]

   set apANS(MATH) \
           [list APmathGUI APsolveMath [list [list MFvarA "" ""] \
	       [list MFoP "+" work.op|PRI|O] [list MFvarB "" ""] \
	       [list MFvarC "" ""]] [list "%-12s %-10s %-12s %-12s"]]

   set apANS(MASK) \
           [list APmaskGUI APsolveMask [list \
	       [list MSKin "" ""] \
	       [list MSKcond "" work.cond|PRI|O] [list MSKval "" ""] \
	       [list MSKvalA "" ""] \
	       [list MSKtar "" ""] [list MSKout "" ""] \
	       [list MSKrfill NO work.rf|PRI|T]] \
	       [list "%-11s %-7s %-8s %-8s %-11s %-11s %-6s"]]

   set apANS(MEM) \
           [list APmemGUI APsolveMEM [list \
               [list MEMvar "" ""] [list MEMpwr "" ""] [list MEMfq "" ""] \
	       [list MEMcoef "" ""] [list MEMbfq "" ""] [list MEMefq "" ""] \
	       [list MEMnfq "" ""] \
	       [list MEMsp LINEAR work.sp|PRI|T] \
	       [list MEMpad YES work.pd|PRI|T] \
	       [list MEMret POWER work.ret|PRI|T]] \
	       [list "%-12s %-12s %-10s %-5s %-7s %-7s %-6s %-8s %-6s %-6s"]]

   set apANS(MVA) \
           [list APmvaGUI APsolveMVA [list \
	       [list MVAtmO "CUSTOM" work.top|PRI|O] \
               [list MVAtmA "" ""] [list MVAtmB "" ""] \
               [list MVAiN "" ""] [list MVAouT "" ""]] \
	       [list "%-10s %-20s %-20s %-12s %-12s"]]

   set apANS(PLASMA) \
           [list APplasmaGUI APsolvePlasma [list [list ppO "" ""] \
	       [list PParm "" work.pop|PRI|O] \
	       [list Comp "I" work.cop|ALT|T] \
	       [list eN "" ""] [list iN "" ""] \
	       [list eT "" ""] [list iT "" ""] \
	       [list mF "" ""] [list Chg "" ""] \
	       [list AmU "" ""]] \
	       [list "%-11s %-13s %-5s %-8s %-8s %-8s %-8s %-8s %-4s %-4s"]]

   set apANS(PRINT) \
           [list APprintGUI APsolvePrint [list [list prFile "" ""] \
	       [list prTm YES work.pt|PRI|T] [list prFmt "%.4e" ""] \
	       [list prVar "" ""]] [list "%-35s %-4s %-7s %-11s"]]

   set apANS(RANDOM) \
           [list APrandomGUI APsolveRandom [list [list BaseV "" ""] \
	       [list RndV "" ""] [list Rng PN work.rng|PRI|O] \
               [list Max 1.0 ""] [list Seed ""] \
	       [list Dist Flat work.dist|PRI|T] [list Mean 0.0] \
	       [list Var 1.0] ] \
               [list "%-12s %-12s %-12s %-7s %-7s %-8s %-8s %-10s %-10s %-10s"]]

   set apANS(RMSPIKE) \
           [list APrmspikeGUI APsolveRmSpike [list [list inArray "" ""] \
	       [list outArray "" ""] [list statArray "" ""] \
               [list MaxSig 3.0 ""] [list intvlLen 20 ""] \
               [list intvlSkip 1 ""] [list intvlFmt TIME work.ifm|PRI|T] \
	       [list Cond "" work.cnd|PRI|O] \
	       [list lT $apANS(BaDU) ""] [list gT $apANS(BaDL) ""] \
	       [list fillIt YES work.gf|PRI|T] ] \
               [list "%-11s %-11s %-11s %-6s %-6s %-6s %-8s %-7s %-8s %-8s %-5s"]]

   set apANS(ROTATION)\
           [list AProtGUI APsolveRot [list [list RVin "" ""] \
               [list RVop "INTO" work.op|PRI|T] [list RVtar "" ""] \
	       [list RVout "" ""]] [list "%-12s %-10s %-12s %-12s"]]

   set apANS(SETV) \
           [list APsetvGUI APsolveSetv [list [list sV "" ""] [list Indx 0 ""] \
               [list V1 "" ""] [list V2 "" ""] [list V3 "" ""] \
	       [list V4 "" ""]] [list "%-12s %-6s %-13s %-13s %-13s %-13s"]]

   set apANS(SPATIAL-DERV) \
           [list APsdGUI APsolveSD [list [list SDxyz "" ""] \
	       [list SDdelay "" ""] [list SDitype "VECTOR" work.it|PRI|T] \
	       [list SDinput "" ""] [list SDext 1 ""] [list SDord 1 ""] \
	       [list SDderiv "" ""] [list SDraw "" ""]] \
	       [list "%-12s %-10s %-7s %-12s %-4s %-4s %-12s %-12s"]]

   set apANS(SPIN-PER) \
           [list APspinGUI APsolveSpin [list [list pHase "" ""] \
	       [list ouTPut "" ""] [list sTatus "" ""] \
	       [list tIme "" ""] [list sPer "" ""] ] \
               [list "%-13s %-13s %-13s %-13s %-13s"]]

   set apANS(STATISTICS) \
           [list APstatGUI APsolveStat [list [list StatI "" ""] \
	      [list StatO "" ""] [list lT $apANS(BaDL) ""] \
	      [list gT $apANS(BaDU) ""]] \
	      [list "%-13s %-13s %-10s %-10s"]]

   set apANS(SURF-VOL) \
           [list APsurfvolGUI APsolveSurfVol [list [list Vertices "" ""] \
	       [list Geom Triangle  work.geom|PRI|O] \
	       [list Meas Surface  work.meas|PRI|O] \
               [list MeaOut "" ""]] \
               [list "%-12s %-12s %-9s %-12s"]]


   set apANS(UNSET) \
           [list APunsetGUI APsolveUnset [list [list USvar "" ""]] \
	       [list "%-15s"]]

   set apANS(VECTOR) \
           [list APvecGUI APsolveVec [list [list VFvarA "" ""] \
               [list VFoP "DOT" work.op|PRI|O] [list VFvarB "" ""] \
	       [list VFvarC "" ""]] [list "%-12s %-10s %-12s %-12s"]]

   set apANS(VMAP) \
           [list APvmapGUI APsolveVMap [list [list vIn "" ""] \
	       [list vMap "" ""]] [list "%-12s %-12s"]]

   set apANS(WAVE-TELESCOPE) \
           [list APwtGUI APsolveWT [list [list WTlocI "" ""] \
	       [list WTfreqO "" ""] [list WTphO "" ""] \
	       [list WTmnFq "" ""] \ [list WTmnK "" ""] \
	       [list WTmnPh 0 ""] [list WTmnTh 0 ""] \
               [list WTfftI "" ""] [list WTkO "" ""] [list WTthO "" ""] \
	       [list WTmxFq "" ""] \ [list WTmxK "" ""] \
	       [list WTmxPh 360 ""] [list WTmxTh 180 ""] \
               [list WTpwrO "" ""] \
	       [list WTstFq 1 ""] \ [list WTstK 1 ""] \
	       [list WTstPh 1 ""] [list WTstTh 1 ""] ] \
	       [list "%-12s %-12s %-12s %-9s %-9s %-9s %-9s" \
	                "%-12s %-12s %-12s %-9s %-9s %-9s %-9s" \
	                "$sP12 $sP12 %-12s %-9s %-9s %-9s %-9s" ] ]
}
