 package provide UDFAnalysis 1.0

proc APplotGrid { pN TiMe } {
   global apANS GphInfo PltInfo

# NEED to save the current tick color and format.  Might as well through
#   in the linestyle

   PLTinfoCur $pN Xb nI tIx 
   PLTinfoCur $pN Yb nI tIy 
   set cCx [lindex tIx 6]
   set cCy [lindex tIy 6]
   set cFx [lindex tIx 0]
   set cFy [lindex tIy 0]

   set cLs $GphInfo(lStyle)

# SET the grid values

   PLTinfoChg $pN Xb TICKS MJPOSITION SPAN
   PLTinfoChg $pN Yb TICKS MJPOSITION SPAN
   PLTinfoChg $pN Xb TICKS MJCOLOR $apANS(gColor)
   PLTinfoChg $pN Yb TICKS MJCOLOR $apANS(gColor)

# AND the linestyle

   LineStyle 0 $apANS(gStyle)

# DRAW the grid as requested   

   switch -exact -- $apANS(gStatus) {
      X  { 
         if [string match YES $TiMe] {
            PLTaxisTime $pN Xb NO NO 0 0 
	 } else { PLTaxisRec $pN Xb ALLMAJOR NONE 0 }
      }
      Y  { PLTaxisRec $pN Yb ALLMAJOR NONE 0 }
      XY { 
         if [string match YES $TiMe] {
            PLTaxisTime $pN Xb NO NO 0 0 
	 } else { PLTaxisRec $pN Xb ALLMAJOR NONE 0 }
         PLTaxisRec $pN Yb ALLMAJOR NONE 0
      }
   }

# RESET the old values.

   PLTinfoChg $pN Xb TICKS MJPOSITION $cFx
   PLTinfoChg $pN Yb TICKS MJPOSITION $cFy
   PLTinfoChg $pN Xb TICKS MJCOLOR $cCx
   PLTinfoChg $pN Yb TICKS MJCOLOR $cCy

   LineStyle 0 $cLs

}
