package provide UDFAnalysis 1.0

proc APplasmaGUI { fD { ImC 0 } } {
  global apANS env Prefs

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   set YN [list NO YES]

   set mN PLASMA
   APallInits FUNCTION $fD
   APallInits $mN $fD

   set pOPs [list GyroFreq GyroRadius PlasmaFreq LowHybrid ThermalVel \
                  AlfvenVel InertialLen]
   set cOPs [list Ion|I Electron|E]

   set W  .apFDEF$fD
   set LaB "$apANS($fD,Func) SETUP"
   if [GUIWindow $W $LaB] {
      if $ImC { GUIwindowCtrl .apFDEF$fD }
      set Wa $W.top
      set Wb $W.com
      set Wc $W.body
      set Wd $W.act
      set We $W.work

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb  2 grid|1|0|w
      GUIFrame $Wc -1 grid|2|0|news
      GUIFrame $Wd -1 grid|3|0|news
      GUIFrame $We -1 grid|4|0|w
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUIblankRow $Wa 1 0.5

      APtopplugGUI $fD $Wb FUNCTION

      set FmT [lindex [lindex $apANS($mN) 3] 0]
      set LaB [format $FmT Output Quanity Comp Ne Ni Te Ti MF AMU Z]

      set R 0
      GUIblankRow $Wc $R 0.5
      incr R 
      GUILabel $Wc.$R $LaB  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 57 7  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false

      GUIbuttonPush $Wd.add  ADD grid|0|0 "APaddPItem $mN $fD FDEF" 6
      GUIblankCol $Wd 1 4
      GUIbuttonPush $Wd.edit EDIT grid|0|2 "APeditPItem $mN $fD FDEF" 6
      GUIbuttonPush $Wd.rep ACCEPT grid|0|3 "APaddPItem $mN $fD FDEF REPLACE" 6
      GUIblankCol $Wd 4 4
      GUIbuttonPush $Wd.unset  UNSET grid|0|5 "APtwinCmd $mN $W UNSET" 6
      GUIbuttonPush $Wd.reset  RESET grid|0|6 "APvarReset $mN $fD" 6
      GUIblankCol $Wd 7 4
      GUIbuttonPush $Wd.delete DELETE grid|0|8 "APtwinCmd $mN $W DELETE" 6

      set R 0
      GUIblankRow $We $R 2.5

      incr R 
      GUIblankCol $We 0 1
      GUILabel $We.l0  "Output" c grid|$R|1|w -1 0 "" $LFonT
      GUIblankCol $We 2 1
      GUIboxEntry $We.bi grid|$R|3|news 11 apANS($fD,ppO)

      incr R 
      GUILabel $We.l2  "Parameter" c grid|$R|1|w -1 0 "" $LFonT
      GUIbuttonMenu $We.pop "" grid|$R|3|ew $pOPs \
                      "GUIoptsProcess $We.pop apANS($fD,PParm) PRI " 0,1
      GUIblankCol $We 4 6
      GUIbuttonToggle $We.cop $apANS($fD,Comp) grid|$R|5|ew $cOPs \
		       "GUIoptsToggle $We.cop apANS($fD,Comp) ALT" 0,1
      GUIblankCol $We 6 1
      GUILabel $We.l3  "Component" c grid|$R|7|w -1 0 "" $LFonT

      incr R 
      GUILabel $We.l4  "e- Density (cc)" c grid|$R|1|w -1 0 "" $LFonT
      GUIboxEntry $We.ed grid|$R|3|news 11 apANS($fD,eN)
      GUIboxEntry $We.id grid|$R|5|nw 11 apANS($fD,iN)
      GUILabel $We.l5  "Ion Density (cc)" c grid|$R|7|w -1 0 "" $LFonT

      incr R 
      GUILabel $We.l6  "e- Temp (eV)" c grid|$R|1|w -1 0 "" $LFonT
      GUIboxEntry $We.et grid|$R|3|news 11 apANS($fD,eT)
      GUIboxEntry $We.it grid|$R|5|nw 11 apANS($fD,iT)
      GUILabel $We.l7  "Ion Temp (eV)" c grid|$R|7|w -1 0 "" $LFonT

      incr R 
      GUILabel $We.l8  "MF (gauss)" c grid|$R|1|w -1 0 "" $LFonT
      GUIboxEntry $We.bo grid|$R|3|news 11 apANS($fD,mF)

      incr R 
      GUILabel $We.l10  "Charge" c grid|$R|1|w -1 0 "" $LFonT
      GUIboxEntry $We.chg grid|$R|3|news 11 apANS($fD,Chg)
      GUIboxEntry $We.amu grid|$R|5|nw 11 apANS($fD,AmU)
      GUILabel $We.l11  "AMU" c grid|$R|7|w -1 0 "" $LFonT

      bind $W <Down> { APtwinCmd FILTER %W MOVE DOWN }
      bind $W <Up> { APtwinCmd FILTER %W MOVE UP }

      APallInits $mN $fD
      if [info exists apANS($mN$fD,rd)] { APfillPLBox $mN $fD FDEF }
      APfillGUI  $mN $fD

   } else { GUIwindowCtrl $W }
}
