package provide UDFAnalysis 1.0

proc APmvaGUI { fD { ImC 0 } } {
   global apANS env Prefs

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   set TmOps [list SYSTEM PLOT CUSTOM]

   set mN MVA
   APallInits FUNCTIOM $fD
   APallInits $mN $fD

   set W  .apFDEF$fD
   set LaB "$apANS($fD,Func) SETUP"
   if [GUIWindow $W $LaB] {
      if $ImC { GUIwindowCtrl .apFDEF$fD }

      set Wa $W.top
      set Wb $W.com
      set Wc $W.body
      set Wd $W.act
      set We $W.work

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb  2 grid|1|0|w
      GUIFrame $Wc -1 grid|2|0|news
      GUIFrame $Wd -1 grid|3|0|news
      GUIFrame $We -1 grid|4|0|w
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUIblankRow $Wa 1 0.5

      APtopplugGUI $fD $Wb FUNCTION

      set FmT [lindex [lindex $apANS($mN) 3] 0]
      set LaB [format $FmT TimeBase T1 T2 Input Output]

      set R 0
      GUIblankRow $Wc $R 0.5
      incr R 
      GUILabel $Wc.$R $LaB  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 55 7  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false

      GUIbuttonPush $Wd.add  ADD grid|0|0 "APaddPItem $mN $fD FDEF" 6
      GUIblankCol $Wd 1 4
      GUIbuttonPush $Wd.edit EDIT grid|0|2 "APeditPItem $mN $fD FDEF" 6
      GUIbuttonPush $Wd.rep ACCEPT grid|0|3 "APaddPItem $mN $fD FDEF REPLACE" 6
      GUIblankCol $Wd 4 4
      GUIbuttonPush $Wd.unset  UNSET grid|0|5 "APtwinCmd $mN $W UNSET" 6
      GUIbuttonPush $Wd.reset  RESET grid|0|6 "APvarReset $mN $fD" 6
      GUIblankCol $Wd 7 4
      GUIbuttonPush $Wd.delete DELETE grid|0|8 "APtwinCmd $mN $W DELETE" 6

      set YN [list NO|0 YES|1]

      set R 0
      GUIblankRow $We $R 2.5

      GUILabel $We.l1a "Base" c grid|$R|1|ew 0 0 "" $LFonT
      GUILabel $We.l1b "Start" c grid|$R|2|ew 0 0 "" $LFonT
      GUILabel $We.l1c "Stop" c grid|$R|3|ew 0 0 "" $LFonT

      incr R
      GUIblankRow $We $R 0.5

      incr R 
      GUILabel $We.l$R "Time" c grid|$R|0|w 0 0 "" $LFonT
      GUIbuttonMenu $We.top "" grid|$R|1|ew $TmOps  \
                       "GUIoptsProcess $We.top apANS($fD,MVAtmO) PRI " 6
      GUIboxEntry $We.tma grid|$R|2|news 21 apANS($fD,MVAtmA)
      GUIboxEntry $We.tmb grid|$R|3|news 21 apANS($fD,MVAtmB)

      incr R
      GUIblankRow $We $R 1.0

      incr R
      GUILabel $We.l$R "Inputs"  c grid|$R|0|w 0 0 "" $LFonT
      GUIboxEntry $We.in grid|$R|1|news 12 apANS($fD,MVAiN)

      incr R
      GUIblankRow $We $R 1.0

      incr R
      GUILabel $We.l$R "Outputs"  c grid|$R|0|w 0 0 "" $LFonT
      GUIboxEntry $We.out grid|$R|1|news 12 apANS($fD,MVAouT)

      bind $W <Down> { APtwinCmd BOX %W MOVE DOWN }
      bind $W <Up> { APtwinCmd BOX %W MOVE UP }

      APallInits $mN $fD
      if [info exists apANS($mN$fD,rd)] { APfillPLBox $mN $fD FDEF }
      APfillGUI  $mN $fD

   } else { GUIwindowCtrl $W }
}
