package provide UDFAnalysis 1.0

proc APlayoutGUI { { ImC 0 } } {
  global apANS Prefs GUIoptAlts GUIoptPri

   set W  .apLAYOUT

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   if [GUIWindow $W "PLOT LAYOUT"] {
      if $ImC { GUIwindowCtrl .apLAYOUT }
      set Wa $W.cmd
      set Wc $W.body
      set Wd $W.pid
      set We $W.menu
      set Wf $W.act
      GUIFrame $Wa -1 grid|0|0|news||2
      GUIFrame $Wc -1 grid|2|0|news
      GUIFrame $Wf -1 grid|2|1|n
      GUIFrame $Wd -1 grid|3|0|||2
      GUIFrame $We -1 grid|4|0|||2

      GUIbuttonPush $Wa.close CLOSE pack|right "GUIwindowCtrl $W"  6

      set R 0
      GUIblankRow $Wc $R 1.0

      set FmT "%-4s  %-6s  %-6s  %-6s  %-6s  %-6s"
      set LaB [format $FmT Slot PiD Row Col rSpan cSpan]

      incr R
      GUILabel $Wc.$R $LaB  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 50 10  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false
      incr R
      GUIblankRow $Wc $R 2.0

      set Row 0
      GUIblankRow $Wf $R 2.5
      incr R
      GUIbuttonPush $Wf.add ADD grid|$R|0|w "APaddItem LAYOUT" 3 7
      incr R
      GUIblankRow $Wf $R 0.5
      incr R
      GUIbuttonPush $Wf.edi EDIT grid|$R|0|w "APeditItem LAYOUT" 3 7
      incr R
      GUIblankRow $Wf $R 0.5
      incr R
      GUIbuttonPush $Wf.del DELETE grid|$R|0|w "APdelItem LAYOUT" 3 7
      incr R
      GUIblankRow $Wf $R 1.5
      incr R
      GUIbuttonPush $Wf.acc ACCEPT grid|$R|0|w "APacceptEdit LAYOUT" 3 7
      incr R
      GUIblankRow $Wf $R 0.5
      incr R
      GUIbuttonPush $Wf.rst RESET grid|$R|0|w "APresetMenu LAYOUT" 3 7

      APxferItem LAYOUT INIT 0

      set YN  [list NO|0 YES|1]
      set SCA [list LINEAR|0 LOG|1]
      set vN  [list * xb yl xt yr za cb]
      set NE  [list NONE BOTH MIN MAX ALL]
      set OO  [list OFF ON]
      set TP  [list INSIDE OUTSIDE STRADDLE SPAN]
      set fOpts [list BOX CROSSHAIR POLAR MAP]
      set mOpts [list CARTESIAN LAMBERT_CYLINDRICAL BEHRMANN_CYLINDRICAL \
                      TRISTAN_EDWARDS PETERS GALL_ORTHOGRAPHIC BALTHASART \
		      EQUIRECTANGULAR MILLER37 MILLER43 MILLER50 CYLINDRICAL \
		      CYLINDRICAL_EQUAL_AREA CYLINDRICAL_EQUIDISTANT \
		      ECKERT_SINUSOIDAL ECKERT_ELLIPSOIDAL MERCATOR \
		      MOLLWEIDE ORTHOGRAPHIC SINUSOIDAL STEREOGRAPHIC]

      GUILabel $Wd.c1 "ID" c grid|$R|1|ews 0 0 "" $LFonT
      GUILabel $Wd.c2 "Axis" c grid|$R|2|ews 0 0 "" $LFonT
      GUILabel $Wd.c3 "CoorSys" c grid|$R|3|ews 0 0 "" $LFonT
      incr R

      GUILabel $Wd.l$R "Plot   " c grid|$R|0|w 0 0 "" $LFonT
      GUIboxEntry $Wd.pid grid|$R|1|news 10 apANS(T,piD)
      GUIbuttonMenu $Wd.axis $apANS(T,pAxis) grid|$R|2|ew $fOpts \
	          "GUIoptsProcess $Wd.axis apANS(T,pAxis) PRI " 8
      GUIbuttonMenu $Wd.csys $apANS(T,pCorSys) grid|$R|3|ew $mOpts \
	          "GUIoptsProcess $Wd.csys apANS(T,pCorSys) PRI " 8

      set R 0
      GUIblankRow $We $R 1.0

      incr R
      GUILabel $We.lr "Row" c grid|$R|1|ews 0 0 "" $LFonT
      GUILabel $We.lc "Col" c grid|$R|2|ews 0 0 "" $LFonT
      GUILabel $We.lrs "rSpan" c grid|$R|3|ew 0 0 "" $LFonT
      GUILabel $We.lcs "cSpan" c grid|$R|4|ew 0 0 "" $LFonT
      GUILabel $We.ltm "Time" c grid|$R|5|ew 0 0 "" $LFonT
      GUILabel $We.ldg "Grid" c grid|$R|6|ew 0 0 "" $LFonT

      incr R
      GUILabel $We.l$R "General Info" c grid|$R|0|w 0 0 "" $LFonT
      GUIboxEntry $We.col grid|$R|1|news 9 apANS(T,Row)
      GUIboxEntry $We.row grid|$R|2|news 9 apANS(T,Col)
      GUIboxEntry $We.spc grid|$R|3|news 9 apANS(T,rSpan)
      GUIboxEntry $We.spr grid|$R|4|news 9 apANS(T,cSpan)
      GUIbuttonToggle $We.tm $apANS(T,tBased) grid|$R|5|ew $YN \
                        "GUIoptsToggle $We.tm apANS(T,tBased) PRI"
      GUIbuttonToggle $We.drg $apANS(T,drG) grid|$R|6|ew $YN \
                        "GUIoptsToggle $We.drg apANS(T,drG) PRI"

      set dOpts [list VERTICAL RHORIZONTAL LHORIZONTAL]
      set lOpts [list LEFT RIGHT BOTTOM TOP]
      incr R
      GUILabel $We.l$R "ColorBar" c grid|$R|0|w 0 0 "" $LFonT
      GUIbuttonToggle $We.csh $apANS(T,cBShow) grid|$R|1|ew $YN \
                        "GUIoptsToggle $We.csh apANS(T,cBShow) PRI"
      GUIbuttonMenu $We.cbl $apANS(T,cBLoc) grid|$R|2|ew $lOpts \
	          "GUIoptsProcess $We.cbl apANS(T,cBLoc) PRI "
      GUIboxEntry $We.sbsc grid|$R|3|news 9 apANS(T,cBSpan)
      GUIbuttonMenu $We.cbd $apANS(T,cBDir) grid|$R|4|ew||2 $dOpts \
	          "GUIoptsProcess $We.cbd apANS(T,cBDir) PRI "

      incr R
      GUILabel $We.lcsh "Show" c grid|$R|1|ewn 0 0 "" $LFonT
      GUILabel $We.lcbl "Loc" c grid|$R|2|ewn 0 0 "" $LFonT
      GUILabel $We.lcrs "Span" c grid|$R|3|ewn 0 0 "" $LFonT
      GUILabel $We.lcbd "Dir" c grid|$R|4|ewn||2 0 0 "" $LFonT

      incr R
      GUIblankRow $We $R 1.0 ; incr R

      GUILabel $We.lxb "Bot X" c grid|$R|1|ew 0 0 "" $LFonT
      GUILabel $We.lyl "Left Y" c grid|$R|2|ew 0 0 "" $LFonT
      GUILabel $We.lxt "Top X" c grid|$R|3|ew 0 0 "" $LFonT
      GUILabel $We.lyr "Right Y" c grid|$R|4|ew 0 0 "" $LFonT
      GUILabel $We.lza "Z" c grid|$R|5|ew 0 0 "" $LFonT
      GUILabel $We.lcb "CBar" c grid|$R|6|ew 0 0 "" $LFonT
      incr R

      GUILabel $We.l$R "Minimum" c grid|$R|0|w 0 0 "" $LFonT
      set nE [llength $vN]
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
          GUIboxEntry $We.${V}min grid|$R|$C|news 9 apANS(T,${V}Min)
      }

      incr R
      GUILabel $We.l$R "Maximum" c grid|$R|0|w 0 0 "" $LFonT
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
          GUIboxEntry $We.${V}max grid|$R|$C|news 9 apANS(T,${V}Max)
      }

      incr R
      GUILabel $We.l$R "Scaling" c grid|$R|0|w 0 0 "" $LFonT
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
          GUIbuttonToggle $We.${V}s $apANS(T,${V}Sca) grid|$R|$C|ew $SCA \
                     "GUIoptsToggle $We.${V}s apANS(T,${V}Sca) PRI"
      }

      incr R
      GUILabel $We.l$R "Gap" c grid|$R|0|w 0 0 "" $LFonT
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
          GUIboxEntry $We.${V}gap grid|$R|$C|news 9 apANS(T,${V}Gap)
      }

      incr R
      GUILabel $We.l$R "Annotate" c grid|$R|0|w 0 0 "" $LFonT
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
          GUIbuttonToggle $We.${V}a $apANS(T,${V}Ano) grid|$R|$C|ew $YN \
                        "GUIoptsToggle $We.${V}a apANS(T,${V}Ano) PRI"
      }

      incr R
      GUILabel $We.l$R "Text Size" c grid|$R|0|w 0 0 "" $LFonT
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
          GUIboxEntry $We.${V}tsz grid|$R|$C|news 9 apANS(T,${V}TSz)
      }

      incr R
      GUILabel $We.l$R "Number Format" c grid|$R|0|w 0 0 "" $LFonT
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
          GUIboxEntry $We.${V}nFmt grid|$R|$C|news 9 apANS(T,${V}nFmt)
      }

      incr R
      GUILabel $We.l$R "Bold Numbers" c grid|$R|0|w 0 0 "" $LFonT
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
          GUIbuttonToggle $We.${V}bold $apANS(T,${V}Bold) grid|$R|$C|ew $OO \
                     "GUIoptsToggle $We.${V}bold apANS(T,${V}Bold) PRI"
      }

      incr R
      GUILabel $We.l$R "Number Color" c grid|$R|0|w 0 0 "" $LFonT
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
	  GUIbuttonPush $We.${V}ncol "" grid|$R|$C|news \
	       "GUIcolorPick $We.${V}ncol apANS(T,${V}nCol)"
	  GUIchgConf $We.${V}ncol "" "" "" $apANS(T,${V}nCol) ridge
      }

      incr R
      GUILabel $We.l$R "Omit Numbers" c grid|$R|0|w 0 0 "" $LFonT
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
	  GUIbuttonMenu $We.${V}ends $apANS(T,${V}nEnds) grid|$R|$C|news \
	      $NE "GUIoptsProcess $We.${V}ends apANS(T,${V}nEnds) PRI "
      }

      incr R
      GUILabel $We.l$R "Major Ticks" c grid|$R|0|w 0 0 "" $LFonT
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
          GUIboxEntry $We.${V}mjt grid|$R|$C|news 9 apANS(T,${V}MjT)
      }

      incr R
      GUILabel $We.l$R "Minor Ticks" c grid|$R|0|w 0 0 "" $LFonT
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
          GUIboxEntry $We.${V}mnt grid|$R|$C|news 9 apANS(T,${V}MnT)
      }

      incr R
      GUILabel $We.l$R "Tick Format" c grid|$R|0|w 0 0 "" $LFonT
      for { set C 1 } { $C < $nE } { incr C } {
          set V [lindex $vN $C]
	  GUIbuttonMenu $We.${V}tfmt $apANS(T,${V}tFmt) grid|$R|$C|news \
	      $TP "GUIoptsProcess $We.${V}tfmt apANS(T,${V}tFmt) PRI "
      }

      bind $W <Down> { APtwinCmd MenU %W MOVE DOWN }
      bind $W <Up> { APtwinCmd MenU %W MOVE UP }

      APfillGUI  LAYOUT T
      APfillLBox LAYOUT

      set apANS(LAYOUT,sN) [$Wc.list index end]

   } else { GUIwindowCtrl .apLAYOUT }
}
