package provide UDFAnalysis 1.0

proc APgridData { vD nP tBeg tEnd yBeg yEnd Data Grid Norm } {
   global apANS

   upvar $tBeg tA

# IF there is no ending time or the data is to be stored as a point
#   measurement then the ending time is set to the beginning time,
#   otherwize its as passed in.

   set tMf [string match NO $apANS($vD,tM)]
   set gSf [string match POINT $apANS($vD,gStor)]

   if { $tMf || $gSf } {
      upvar $tBeg tB
   } else { upvar $tEnd tB }

   upvar $Data D
   upvar $Grid G
   upvar $Norm N

   set nE [split $nP ","]
   set DiM [llength $nE]
   set nX [lindex $nE 0]

   if [string match "<" [lindex [split $apANS($vD,gBad)] 0]] {
      set BadL [lindex [split $apANS($vD,gBad)] 1]
   } else { set BadL $apANS(BaDL) }
  if [string match ">" [lindex [split $apANS($vD,gBad)] 0]] {
      set BadU [lindex [split $apANS($vD,gBad)] 1]
   } else { set BadU $apANS(BaDU) }

   if { $DiM == 1 } {
      set Y(0) 0.0

# IF this is not a time based grid then the grid length is set to the 
#    data array length

      if $tMf {
	 set gC [list 0 0 1 $nX 4 $nX 13 $BadL 14 $BadU]
      } else { set gC [list 13 $BadL 14 $BadU] }


      APmakeGrid gI $apANS($vD,gStor) $gC $apANS($vD,gdT)

      TUdataGrid $nX 1 tA tB $nX Y Y D G N gI

# ADD grid information to data

      APxferGInfo gI G GI

# FILL grid in necessary

      if [string match YES $apANS($vD,gFill)] { TUgridFill1D G gI X LI -1 1 N }

   } else {
      upvar $yBeg Ya
      upvar $yEnd Yb
      set nY [lindex $nE 0]
   }
}
