package provide UDFAnalysisTh 1.0

proc APgetData { } {
   global apANS

# IF we have already read the data then no need to do it again

   if [string match YES [tsv::get apANS GotData] ] { return }

# CREATE and fill variable window if it does not exist

   if ![winfo exists .apVAR] { APvarGUI 1 }
         
# CURRENT source definitions are in this window 

   set W .apVAR.body.list
	       
# THIS is the number of source definitions
	          
   set nS [$W index end]
		        
# LOOP over the sources.

   for { set I 0 } { $I < $nS } { incr I } {
      set sDef [$W get $I]
      scan $sDef "%d" sN
      if [string match ASCII [tsv::get apANS $sN,Src] ] {
         switch -exact -- [tsv::get  apANS $sN,aFmt]  {
            MOM-UDF { APreadMOM $sN }
            GENERIC { APreadGeneric $sN }
         }
      } else { APreadUDF $sN }
   }

# ACKNOWLEDGE we've read the data

   set apANS(GotData) YES
   tsv::set apANS GotData YES
}
