package provide UDFAnalysis 1.0

proc APgenLab { I { MkV 0 } } {
   global apANS 

# UNICODE check (\u == unicode)

   set iLaB $apANS($I,Lab)
   set oLaB [APucodeParse $iLaB]

# BREAK apart the label and check to see if there are any embedded 
#   variables in it.  Assume that any word in a label which begins 
#   with $ is a variable.  If it had __ appended to it what follows
#   that is a format statement.  If there is no format then the
#   variable is output as %s.  If the varaible name is apANS then
#   assume its an internal variable otherwise its one of the global
#   varaibles defined within the program to hold data or data products.
#   Need to reassemble the label when done

   set iLaB $oLaB
   set oLaB ""
   set Done 0

   set sLen [string length $iLaB]
   while { !$Done } {
      set vLoc [string first "$" $iLaB]
      if { $vLoc >= 0 } {
         if { $vLoc > 0 } {
            append cL [string range $iLaB 0 [expr $vLoc - 1]]
            set iLaB [string range $iLaB $vLoc end]
         }

# VARIABLE can end in space or ampersand.  If its neither then the
#   variable ends the label.  Since there may be multiple instances
#   of spaces and ampersands in the line the closest to the variable
#   definition is the one used.

         set vE [expr [string length $iLaB] - 1]
         set sLoc [string first " " $iLaB]
         if { $sLoc <= 0 } { set sLoc $vE }
         set aLoc [string first "@" $iLaB]
         if { $aLoc <= 0 } { set aLoc $vE }
         if { $sLoc < $aLoc } { set vE [expr $sLoc - 1] } else { set vE $aLoc }

         set vAr [string range $iLaB 0 $vE]
         incr vE
	 if { $vE >= [string length $iLaB] } { 
	    set Done 1
         } else { set iLaB [string range $iLaB $vE end] }

# PROCESS the variable

         set vAr [string trimright $vAr "@"]
         set dLoc [string first "__" $vAr]
         if { $dLoc > 0 } {
            set B [string range $vAr 1 [expr $dLoc - 1]]
            set FmT [string range $vAr [expr $dLoc + 2] end]
         } else {
            set B [string range $vAr 1 end]
	    set FmT %s
         }

         set Op [string first "(" $B]
	 if { $Op >= 0 } {
	    set IsArray 1
            set Cp [string first ")" $B]
            set V  [string range $B 0 [expr $Op - 1]]
            set Ix [string range $B [expr $Op + 1] [expr $Cp -1]]
         } else {
	    set IsArray 0
            set V [string range $B 0 end]
	 }

         if [string match apANS $V] {
            set X \$$V\($Ix\) 
         } else {
	    set Var $V ; global [set Var] ; upvar 0 [set Var] gV
	    if $IsArray {
               set X \$gV\($Ix\) 
            } else { set X $gV }
         }
         set Y [eval format $FmT $X]
         append cL $Y

      } else { append cL $iLaB ; set Done 1 }
   } 
   
   switch -exact -- $cL {
      _S_TiMe_ {
         set oLaB [TUtimeFmt 0 $apANS(PbegYr) $apANS(PbegDy) $apANS(PbegMs)]
      }
      _E_TiMe_ {
         set oLaB [TUtimeFmt 0 $apANS(PendYr) $apANS(PendDy) $apANS(PendMs)]
      }
      _SE_TiMe_ {
         set oLaB [TUtimeFmt 0 $apANS(PbegYr) $apANS(PbegDy) $apANS(PbegMs)]
	 append oLaB " TO "
         append oLaB [TUtimeFmt 0 $apANS(PendYr) $apANS(PendDy) $apANS(PendMs)]
      }
      default { set oLaB $cL }
   }

# IF we need to make the label vertical do it here

   if $MkV {
      set cL $oLaB
      set oLaB ""
      set I 0
      set sL [expr [string length $cL] - 1]
      while { $I <= $sL } {
         set Add [string index $cL $I]
	 if { $Add == "\\" } {
	    incr I
	    if { $I <= $sL } {
	       set cH [string index $cL $I]
	       if [string match $cH "u"] {
	          set BeG [expr $I + 1]
	          set EnD [expr $I + 4]
	          if { $EnD <= $sL } {
	             incr I 4
                     set Add [string range $cL $BeG $EnD]
                     scan $Add %x Add
	             set Add [format %c $Add]
	          } else { set Add [string range $cL $BeG $I] }
               } else { set Add [string range $cL $BeG $I }
            }
         }
         if { $I != $sL } { append oLaB "${Add}\n" } else { append oLaB $Add }
         incr I
      }
   }

   return $oLaB
}
