package provide UDFAnalysis 1.0

proc APfillHoles { nE DaTa Method { mGap -1 } { eXtenD 1 } { Cyclic 0 } } {

   upvar $DaTa V

# CREATE the status array

   APbadGrid FLAG $nE V S

   if { $mGap < 0 } { set mGap $nE } else { incr mGap 2 }

# SET up some universal variables from how the gaps in the grid are to be
#   filled.

   switch -exact -- $Method {
      HF {  set P1 { $LastG % $MoD }  
            set P2 { $LastG % $MoD }  
      }
      HB {  set P1 { $J % $MoD }
            set P2 { $J % $MoD }  
      }
      LI -
      HM {  set P1 { $LastG % $MoD }  
            set P2 { $J % $MoD }
      }
   }
   set P3 { $J % $MoD }

# BEGIN loop over data

   set Trigger 0

# FIND the first filled element in the array

   set J 0
   while { $J < $nE } {
      if { $S($J) == 0.0 } { incr J } else { break }
   }

# IF there are no filled elements then there is nothing we can do

   if { $J >= $nE } { return }

# SAVE the location of the value first and update pointer to next.

   set pFlg 0
   if { ($J != 0) && $eXtenD } { set eFlg 1 } else { set eFlg 0 }
   set LastG $J
   incr J

# IF this row or column contain cyclic data then we need to provide an effective
#   column or row end which will end up on the first found grid point. 

   if { $Cyclic } { 
      set EffEnD [expr $J + $nE ] 
      set MoD $nE
   } else { set EffEnD $nE ; set MoD 100000000 }

# NOW loop over the remaining points finding the next filled location 
#   and then iterate between them.  
#
# NOTE the cyclic check on J to reset I if necessary

   while { $J < $EffEnD } {
      while { $J < $EffEnD } {
         set P [expr $J % $MoD]
         if { $S($P) == 0.0 } { incr J } else { break }
      }
      if { $J >= $EffEnD } { 
         if { $pFlg && $eXtenD } {
            set eFlg 2
            set J $EffEnD
         } else { continue } 
      }

# IF this difference is greater than 1 then there is a gap that needs to be
#  filled.  There are four ways to fill this gap:  we can project the last
#  good value through the gap (HF);  we can project the current value back 
#  through the gap (HB); we can project the last and current values into 
#  the gap to meet at the middle (HM); or we can use a linear interpolation 
#  through the gap using the last and current valid grid values (LI).

      if { $eFlg != 2 } {
         set BeG [expr $LastG + 1]
         set V1 $V([expr $P1])
         set V2 $V([expr $P2])

         set GaP [expr $J - $BeG]
         if { ($GaP <= 0) || ($GaP > $mGap) } { 
	    set rV  [list 0 0] 
	 } else {
            switch -exact -- $Method {
               HF -
               HB -
               HM {
                  set rV [list 0 0 ]
                  set Half [expr int($GaP / 2)]
                  set StoP [expr $BeG + $Half]
                  for { set I $BeG } { $I < $StoP } { incr I } {
                     set P [expr $I % $MoD]
                     set V($P) $V1
                  }
                  set BeG $StoP
                  for { set I $BeG } { $I < $J } { incr I } {
                     set P [expr $I % $MoD]
                     set V($P) $V2
                  }
               }
      
               LI {
                  set A [expr ($V2 - $V1) / double($GaP + 1)]
                  set B [expr $V1 - $A * ($BeG - 1)]
                  for { set I $BeG } { $I < $J } { incr I } {
                     set P [expr $I % $MoD]
                     set V($P) [expr $A * $I + $B]
                  }
                  set rV [list $A $B ]
               }
            }
         }
         set Va $V1
         set Vb $V([expr $P3])
         set pFlg 1
      }

      if { $eFlg != 0 } {
         if { $eFlg == 1 } {
            set BeG 0
            set EnD $LastG
             set A [lindex $rV 0]
             set B [lindex $rV 1]
             set V1 [expr $A * ($BeG - 1.0) + $B]
             set V2 [expr $A * $EnD + $B]
         } else { set BeG [expr $LastG + 1] ; set EnD $J }

         if [string match $Method LI] { 
             set A [lindex $rV 0]
             set B [lindex $rV 1]
             set V1 [expr $A * ($BeG - 1.0) + $B]
             set V2 [expr $A * $EnD + $B]
         } else { set V1 $Va ; set V2 $Va }

         set GaP [expr $J - $BeG]
         switch -exact -- $Method {
            HF -
            HB -
            HM {
               set Half [expr int($GaP / 2)]
               set StoP [expr $BeG + $Half]
               for { set I $BeG } { $I < $StoP } { incr I } {
                  set P [expr $I % $MoD]
                  set V($P) $V1
               }
               set BeG $StoP
               for { set I $BeG } { $I < $EnD } { incr I } {
                  set P [expr $I % $MoD]
                  set V($P) $V2
               }
            }
            LI {
               set A [expr ($V2 - $V1) / double($GaP + 1)]
               set B [expr $V1 - $A * ($BeG - 1)]
               for { set I $BeG } { $I < $EnD } { incr I } {
                  set P [expr $I % $MoD]
                  set V($P) [expr $A * $I + $B]
               }
            }
         }
         set eFlg 0
      }

      set Va $Vb
      set LastG $J
      incr J
   }
}
