package provide UDFAnalysisTh 1.0

# SETS up a mask grid build from a variable
#
#   FLAG    - 0 = BAD cells 1 = GOOD cells
#   AFLAG   - same as FLAG but uses previous array and sets only BAD
#   RESET   - flags the bad cells in an array from a mask
#   CANDF   - FLAG with setting the bad array cells to ChgTo
#   ==      - values == to V1 are set to 0 all the rest to 1
#   !=      - values != to V1 are set to 0 all the rest to 1
#   >=      - values >= to V1 are set to 0 all the rest to 1
#   >       - values > to V1 are set to 0 all the rest to 1
#   <=      - values <= to V1 are set to 0 all the rest to 1
#   <       - values < to V1 are set to 0 all the rest to 1
#   ><      - values > V1 && values < V2 are set to 0 all the rest to 1
#   >=<=    - values >= V1 && values <= V2 are set to 0 all the rest to 1
#   >=<     - values >= V1 && values < V2 are set to 0 all the rest to 1
#   ><=     - values > V1 && values <= V2 are set to 0 all the rest to 1
#   >or<    - values > V1 || values < V2 are set to 0 all the rest to 1
#   >=or<=  - values >= V1 || values <= V2 are set to 0 all the rest to 1
#   >=or<   - values >= V1 || values < V2 are set to 0 all the rest to 1
#   >or<=   - values > V1 || values <= V2 are set to 0 all the rest to 1
#
#   NOTE: The AFLAG nD entry can be given as
#               [Length of Status Array],[Length of input Array]
#                
#   In this case the number of values in the input array is repeatedly
#   applied to the status array.  

proc APbadGrid {AcT nD Grid Status { ChgTo 0 } { V1 UNSET } { V2 UNSET }} {

   upvar $Grid G
   upvar $Status S

   if [string match UNSET $V1] { set V1 [tsv::get apANS BaDL] }
   if [string match UNSET $V2] { set V2 [tsv::get apANS BaDU] }

   switch -exact -- $AcT {
      INIT {
         for { set I 0 } { $I < $nD } { incr I } { set S($I) 1 }
      }
      AFLAG {
         set nV [split $nD ","]
	 if { [llength $nV] == 1 } {
	    set nA $nD ; set nB $nD
         } else {
	   set nA [lindex $nV 0]
	   set nB [lindex $nV 1]
	 }

         for { set I 0 } { $I < $nA } { incr I } {
	    set J [expr $I % $nB]
            if { $G($J) <= $V1 } { set S($I) 0 }
         }
      }
      <= -
      FLAG {
         for { set I 0 } { $I < $nD } { incr I } {
            if { $G($I) <= $V1 } { set S($I) 0 } else { set S($I) 1 }
         }
      }
      RESET {
         if [info exist G(gInE)] { set V1 $G(gI11) }
         for { set I 0 } { $I < $nD } { incr I } {
            if !$S($I) { set G($I) $V1 } 
         }
      }
      FANDC {
         for { set I 0 } { $I < $nD } { incr I } {
            if { $G($I) <= $V1 } { 
	       set S($I) 0 ; 
	       set G($I) $ChgTo 
	    } else { set S($I) 1 }
         }
      }
      == {
         for { set I 0 } { $I < $nD } { incr I } {
            if { $G($I) == $V1 } { set S($I) 0 } else { set S($I) 1 }
         }
      }
      != {
         for { set I 0 } { $I < $nD } { incr I } {
            if { $G($I) != $V1 } { set S($I) 0 } else { set S($I) 1 }
         }
      }
      < {
         for { set I 0 } { $I < $nD } { incr I } {
            if { $G($I) < $V1 } { set S($I) 0 } else { set S($I) 1 }
         }
      }
      <= {
         for { set I 0 } { $I < $nD } { incr I } {
            if { $G($I) <= $V1 } { set S($I) 0 } else { set S($I) 1 }
         }
      }
      > {
         for { set I 0 } { $I < $nD } { incr I } {
            if { $G($I) > $V1 } { set S($I) 0 } else { set S($I) 1 }
         }
      }
      >= {
         for { set I 0 } { $I < $nD } { incr I } {
            if { $G($I) >= $V1 } { set S($I) 0 } else { set S($I) 1 }
         }
      }
      >< {
         for { set I 0 } { $I < $nD } { incr I } {
            if { ($G($I) > $V1) && ($G($I) < $V2) } { 
	       set S($I) 0 
            } else { set S($I) 1 }
         }
      }
      >=<= {
         for { set I 0 } { $I < $nD } { incr I } {
            if { ($G($I) >= $V1) && ($G($I) <= $V2) } { 
	       set S($I) 0 
            } else { set S($I) 1 }
         }
      }
      >=< {
         for { set I 0 } { $I < $nD } { incr I } {
            if { ($G($I) >= $V1) && ($G($I) < $V2) } { 
	       set S($I) 0 
            } else { set S($I) 1 }
         }
      }
      ><= {
         for { set I 0 } { $I < $nD } { incr I } {
            if { ($G($I) > $V1) && ($G($I) <= $V2) } { 
	       set S($I) 0 
            } else { set S($I) 1 }
         }
      }
      >or< {
         for { set I 0 } { $I < $nD } { incr I } {
            if { ($G($I) > $V1) || ($G($I) < $V2) } { 
	       set S($I) 0 
            } else { set S($I) 1 }
         }
      }
      >=or<= {
         for { set I 0 } { $I < $nD } { incr I } {
            if { ($G($I) >= $V1) || ($G($I) <= $V2) } { 
	       set S($I) 0 
            } else { set S($I) 1 }
         }
      }
      >=or< {
         for { set I 0 } { $I < $nD } { incr I } {
            if { ($G($I) >= $V1) || ($G($I) < $V2) } { 
	       set S($I) 0 
            } else { set S($I) 1 }
         }
      }
      >or<= {
         for { set I 0 } { $I < $nD } { incr I } {
            if { ($G($I) > $V1) || ($G($I) <= $V2) } { 
	       set S($I) 0 
            } else { set S($I) 1 }
         }
      }
   }
}
