# FOR time based data procedure assumes that each line contains a time 
#   taq which provides the year, dayofyear (or month day), hour, minute, 
#   second, and possibly  millisecond.  There can be a beginning and 
#   ending time tag.  The beginning times should have been labeled bY, bD, 
#   (bMo bD), bH, bM, bS, bMs and if there is an ending time eY, eD, 
#   (eMo, eD), eH, eM, eS, and eMs.  As stated above neither eMs nor bMs 
#   need be used.  Also milliseconds may be included as fractional seconds.
#
#   If there is not ending Year/Day but there is an ending time then the
#   starting Year/Day is used with the day incremented if the ending time 
#   is less than the starting time.
#
#   Variables are assumed to start with _

package provide UDFAnalysis 1.0

proc APasciiTBase { vD fd nLines rCmD rRep rAdv rLine } {
   global apANS 

   upvar $rCmD rC
   upvar $rRep rP
   upvar $rAdv rI

#  USER specified beginning time which is in the format needed to convert the
#    times to "grid" times

   set ubT [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]

# SET the offset of the ending time.

   set ueT [list $apANS(endYr) $apANS(endDy) $apANS(endMs) 0]
   set tEnD [TUtimeConv $ubT $ueT 0 apANS(tBase)]

# INITIALIZE the beginning and ending month and millisecond to 0 and the
#   the ending year to -1.

   set eY -1
   set bMo 0 ; set eMo 0
   set bH 0  ; set eH -1
   set bM 0  ; set eM -1
   set bS 0  ; set eS -1
   set bMs 0 ; set eMs 0

# SET up the variable array increment counters.  There is one per
#   defined line definition.
 
  for { set L 0 } { $L < $nLines } { incr L } { set vC($L) 0 }
 
# READ in the entire data file
#
# SKIP over any leading comment lines

   set _bC 0
   set DonE 0
   set EOF [gets $fd LiNe]

   set _cL [string first $apANS($vD,Comment) $LiNe]
   while { $EOF >= 0  && ($_cL == 0) } {
      set EOF [gets $fd LiNe]
      set _cL [string first $apANS($vD,Comment) $LiNe]
   }

   set First 1 
   while { $EOF >= 0 && !$DonE } {
      if { $EOF > 0 } {
         for { set I 0 } { $I < $nLines } { incr I } {
	    set J 0
	    while { ($EOF >= 0) && ($J < $rP($I)) } {
	       set _N [expr $rI($I) * $vC($I)]
               eval $rC($I)
	       incr vC($I)
	       incr J
	       set EOF [gets $fd LiNe]
               set _cL [string first $apANS($vD,Comment) $LiNe]
               while { $EOF >= 0  && ($_cL == 0) } {
                  set EOF [gets $fd LiNe]
                  set _cL [string first $apANS($vD,Comment) $LiNe]
               }
	    }
	 }

# IF this is the first entry then check for an ending time

         if $First {
	    set First 0
            if { $eY >= 0 } { 
               set eTime 1 
            } elseif { $eH > 0 } { 
                set eTime 2 
            } else { set eTime 0 }
         }

         if { $bMo > 0 } {
            set YD [TUtimeFmt 5 $bY $bMo $bD]
            scan $YD "%4d%3d" bYr($_bC) bDy($_bC)
         } else { set bYr($_bC) $bY; set bDy($_bC) $bD }
         set bT($_bC) [expr int(($bH * 3600 + $bM * 60 + $bS) * 1000 + $bMs)]
         set T [list $bYr($_bC) $bDy($_bC) $bT($_bC) 0]
         set tMb($_bC) [TUtimeConv $ubT $T 0 apANS(tBase)]

         if { $eTime > 0 } {
            set eT [expr int(($eH * 3600 + $eM * 60 + $eS) * 1000 + $eMs)]
	    if { $eTime == 1 } {
               if { $bMo > 0 } {
                  set YD [TUtimeFmt 5 $eY $eMo $eD]
                  scan $YD "%4d%3d" eY eD
               }
            } else { 
               set eY $bYr($_bC)
               set eD $bDy($_bC)
	       if { $bT($_bC) > $eT } {
	          incr eD 1
	          if { $eD > [TUyearLeap $eY] } {
                     incr eY 1
	             set eD 1
                  }
	       }
	    }

            set T [list $eY $eD $eT 0]
            set tMe($_bC) [TUtimeConv $ubT $T 0 apANS(tBase)]
            if { $tMe($_bC) > 0 } {
	       if { $tMb($_bC) < $tEnD } { incr _bC } else { set DonE 1 }
            }
         } else {
            if { $tMb($_bC) >= 0 } {
	       if { $tMb($_bC) < $tEnD } { incr _bC } else { set DonE 1 }
            } else {
               for { set L 0 } { $L < $nLines } { incr L } { set vC($L) 0 }
            }
         }
      }
   }

# CLOSE the data file

   close $fd

# GET the array size.  

   set aSize 1
   for { set I 0 } { $I < $nLines } { incr I } {
      set tSz [expr $rI($I) * $rP($I)]
      if { $tSz > $aSize } { set aSize $tSz }
   }

# ARRAY data can't be gridded --- at least here
 
   if { $aSize == 1 } { set gData $apANS($vD,gData) } else { set gData NO }

# SHOULD we try and set and ending time to each measurement if one has not
#   been provided?

   if { [string match YES $apANS($vD,eTime)] && ($eTime == 0) } {
      set eTime 1

# DETERMINE the time between successive measurements in Ms 

      set I 0; set J 1 ; set K 2 ; set L 3
      set R 10.0

         set dT1 [expr double($bT($J) - $bT($I))]
         set dT2 [expr double($bT($L) - $bT($K))]
         set R [expr $dT2 / $dT1]
      while { (($R > 1.1) || ($R < 0.9)) && ($L < $_bC) } {
         set dT1 [expr double($bT($J) - $bT($I))]
         set dT2 [expr double($bT($L) - $bT($K))]
         set R [expr $dT2 / $dT1]
	 incr I ; incr J ; incr K ; incr L
      }

#  AND given that form the beginning and end times for the measurements

      set dT [expr int(($dT1 + $dT2) / 2.0)]
      for { set I 0 } { $I < $_bC } { incr I } {
         set Ms [expr $bT($I) + $dT]
         if { $Ms > 86400000 } {
            set Ms [expr $Ms - 86400000]
	    incr bDy($I) 1
	    if { $bDy($I) > [TUyearLeap $bYr($I)] } {
               incr bYr($I) 1
	       set bDy($I) 1
            }
          }
          set T [list $bYr($I) $bDy($I) $Ms 0] 
          set tMe($I) [TUtimeConv $ubT $T 0 apANS(tBase)]
      }
   }


#  GET the variable names and the elements we are to get

   set vI [APgetVNames $apANS($vD,aVar)]
   set mN [lindex $vI 0]
   set vI [APgetVNames $apANS($vD,Var)]
   set vN [lindex $vI 0]

   set nE [llength $mN]

#  GET and store the data.  The data is either placed into the system
#  time gird or stored as an array of values.

   for { set I 0 } { $I < $nE } { incr I } {
      set Var  [lindex $vN $I]
      global [set Var]
      upvar 0 [set Var] GriD

      APkeepTabs "CREATING $Var"

      set iName [lindex $mN $I]

      if [string match YES $gData] {
         if { $eTime > 0 } {
            APgridData $vD $_bC tMb tMe Y Y  $iName GriD NorM
         } else { APgridData $vD $_bC tMb tMb Y Y  $iName GriD NorM }

         set GriD(Dim) [list $GriD(gI4) 1]
      } else {
         upvar 0 $iName _TmP_

         set totV [expr $_bC * $aSize]
         for { set J 0 } { $J < $totV } { incr J } { set GriD($J) $_TmP_($J) }
         set GriD(Dim) [list $_bC $aSize]
      }
   }

# SAVE the time variables if we need to.

   set vA [lindex [APgetVNames $apANS($vD,tmV)] 0]
   set nV [llength $vA]
   if  { $nV > 0 } {
      set Var  [lindex $vA 0] ; global [set Var]
      upvar 0 [set Var] tV
      for { set J 0 } { $J < $_bC } { incr J } { set tV($J) $tMb($J) }
      set tV(Dim) [list $_bC 1]

      if { ($eTime > 0) && ($nV > 1) } {
         set Var  [lindex $vA 1] ; global [set Var]
         upvar 0 [set Var] tV
         for { set J 0 } { $J < $_bC } { incr J } { set tV($J) $tMe($J) }
         set tV(Dim) [list $_bC 1]
      }
   }
}
