
package provide UDFAnalysis 1.0

proc APxferGInfo { From To { SrcType DATA } { Dir FORWARD } } {
   global apANS

   upvar $From Src
   upvar $To   Tar

# MAKE sure there is grid information!

  if ![info exists Src(gInE)] { return } 

# SET target index prefex.  This is gI if copying forward and "" if
#   reverse (recreating the basic gI array

  if [string match FORWARD $Dir] { set PR gI } else { set PR "" }

# NUMBER of elements in basic gI array

  set nGE $Src(gInE)

# COPY differently if Src is DATA variable or straight GI definition.

  if [string match DATA $SrcType] {
      for { set I 0 } { $I < $nGE } { incr I } { set Tar($PR$I) $Src(gI$I) }
   } else {
      for { set I 0 } { $I < $nGE } { incr I } { set Tar($PR$I) $Src($I) }
   }

# TRANSFER the cell width in seconds and the number of gI elements.  If they
#   are not available - create them

   if [info exists Src(gInE)] {
      set Tar(gInE) $Src(gInE)
   } else { set Tar(gIcZ) $apANS(numGI) }

   if [info exists Src(gItB)] { set Tar(gItB) $Src(gItB) } 

   if ![info exists Src(gIcZ)] {
      set dT [expr $Tar(gI1) - $Tar(gI0)]
      set Tar(gIcZ) [expr $dT / $Tar(gI4)]
   } else { set Tar(gIcZ) $Src(gIcZ) }
}
