# THIS gets a line of information to go into a text window

package provide UDFAnalysis 1.0

proc APtwinLab { Menu I TLines } {
   global apANS 

   upvar $TLines LaB

   APallInits $Menu $I

# DEFAULT the number of text lines to add to 1.  THIS is true for all 
#   menus which are not part of a FUNCTION definition.

   set nL 1

   switch -exact -- $Menu {
      FUNCTION {
         set FmT(0) "%2d $apANS(FuncTf)"
         set vList(0) [list $I $apANS($I,DoA) $apANS($I,Func) $apANS($I,Com)]
         set fList(0) [list %2d %s %s %s]
      }
      GOBJ {
         set FmT(0) "%2d $apANS(gObjTf)"
         set vList(0) [list $I $apANS($I,gFirst) $apANS($I,gObj) \
	                    $apANS($I,gCom)]
         set fList(0) [list %2d %s %s %s]
      }
      LABEL {
         set FmT(0) "%-4s  %-25s  %-6s  %-8s  %-5s  %-5s"
         if { [string length $apANS($I,Lab)] > 25 } {
            set vL [string range $apANS($I,Lab) 0 20]
            append vL " ..."
         } else { set vL $apANS($I,Lab) }
         set vList(0) [list $I $vL $apANS($I,Lpid) \
	                     $apANS($I,Lcol) $apANS($I,Lsize) \
	                     $apANS($I,Lbold)]
	 set fList(0) [list %4d %s %s %s %s %s]
      }
      PLOT {
         set FmT(0) "%-4s  %-6s  %-9s  %-12s  %-12s  %-12s  %-12s"
         set vList(0) [list $I $apANS($I,pID) $apANS($I,pType) \
                               $apANS($I,VarX) $apANS($I,VarY) \
                               $apANS($I,VarZ) $apANS($I,VarI)]
         set fList(0) [list %4d %s %s %s %s %s %s]
      }
      LAYOUT {
         set FmT(0) "%-4s  %-6s  %-6s  %-6s   %-6s  %-6s"
         set vList(0) [list $I $apANS($I,piD) $apANS($I,Row) \
                             $apANS($I,Col) $apANS($I,rSpan) \
	                     $apANS($I,cSpan)]
         set fList(0) [list %4d %s %3d %3d %3d %3d]
      }
      VARIABLE {
         set FmT(0) "%2d $apANS(VarTf)"
         if { [string length $apANS($I,Var)] > 33 } {
            set vL [string range $apANS($I,Var) 0 28]
            append vL " ..."
         } else { set vL $apANS($I,Var) }

         set vList(0) [list $I $vL $apANS($I,Src) $apANS($I,gFill)]
         set fList(0) [list %2d %s %s %s]
      }

      default {

# THIS is where function menus are moved from the work area to the text
#    window.  The information in the text window can occupy more than one
#    line of text

         if [info exists apANS($Menu)] {
	    set nV [APvarList $Menu vL]
	    set nC 0
	    set nL [llength [lindex $apANS($Menu) 3]]
	    for { set K 0 } { $K < $nL } { incr K } {
               set FmT($K) [lindex [lindex $apANS($Menu) 3] $K]
	       set nE [llength $FmT($K)]

	       set vList($K) "" ; set fList($K) ""

	       for { set J 0 } { $J < $nE } { incr J ; incr nC } {
	          set vI [lindex $vL $nC]
	          set vN [lindex $vI 0]
	          lappend vList($K) $apANS($I,$vN)
	          lappend fList($K) %s
                }
            }
         } else { return 0 }
      }
   }

   for { set K 0 } { $K < $nL } { incr K } {
      set nO [llength $vList($K)]
      set CmD [list format $FmT($K)]
      for { set J 0 } { $J < $nO } { incr J } {
         set V [lindex $vList($K) $J]
         set P $V
         if { [string length $V] == 0 } {
            set P $apANS(EmptyVar)
         } else { 
            if [regexp {^[+-]?[0-9]+$} $V)] { 
               set P [format [lindex $fList($K) $J] $V] 
            }
         }

         lappend CmD $P
      }
      set LaB($K) [eval $CmD]
   }

   return $nL
}
