package provide UDFAnalysis 1.0

# This routine determines the start and stop grids covered by the plot time
#   in a time based data grid.

proc APtimeSpan { Var bG eG { vT DATA } } {
   global apANS 

   upvar $bG  BeG
   upvar $eG  EnD

   set OKgI 1

# BUILD the standard grid infomation array

   set BeG 0
   if [string match DATA $vT] {
      upvar $Var V
      APxferGInfo V gI DATA REVERSE 
   }  else { upvar $Var gI }

   if ![info exists gI(4)] {
      set EnD [expr [lindex $V(Dim) 0] - 1 ]
      return
   } else { set EnD [expr $gI(4) - 1] }

   if $OKgI {
      set ubT [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]
      set Tb [list $apANS(PbegYr) $apANS(PbegDy) $apANS(PbegMs) 0]
      set Te [list $apANS(PendYr) $apANS(PendDy) $apANS(PendMs) 0]
      set tMb [TUtimeConv $ubT $Tb 0 apANS(tBase)]
      set tMe [TUtimeConv $ubT $Te 0 apANS(tBase)]
      TUgridInfo 0 gI gVal $tMb 0.0
      if { $gVal(0) >= 0 } { set BeG $gVal(0) }
      TUgridInfo 0 gI gVal $tMe 0.0
      if { $gVal(0) >= 0 } { set EnD $gVal(0) }
   }
}
