package provide UDFAnalysis 1.0

proc APsrcGUI { sN } {
   global apANS env Prefs

   set W  .apSRC$sN

   set LaB "SOURCE $sN DEFINITION"

   set YN [list NO|0 YES|1]

   if [GUIWindow $W $LaB] {

      set Wa $W.top
      set Wd $W.top.var
      set We $W.top.close
      set Wb $W.menu
      set Wc $W.body
      set Wf $W.anc
      set Ws $W.space

      set bSize [expr $Prefs(FontSize) + 2]
      set LFonT [list "" "" bold]
      set BFonT [list "" $bSize bold]

      GUIFrame $Wa -1 grid|0|0|news||3
      GUIFrame $Wd -1 pack|left
      GUIFrame $We -1 pack|right|ne
      GUIFrame $Wb  2 grid|1|0|nw|
      GUIFrame $Wf  2 grid|2|0|nw|
      $Wb configure -relief raised
      GUIFrame $Ws -1 grid|1|1|news 20
      GUIFrame $Wc -1 grid|1|2|news|2
      $Wc configure -relief groove
      $Wf configure -relief groove

      APallInits VARIABLE $sN

      GUIbuttonPush $We.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUILabel $Wd.lvar "Variables" w grid|0|0|w 6 0 "" $BFonT
      GUIboxEntry $Wd.var grid|0|1|ew 45 apANS($sN,Var)

      if [string match UDF $apANS($sN,Src)] {
         GUILabel $Wd.lind "Indices" w grid|1|0|w 6 0 "" $BFonT
         GUIboxEntry $Wd.ind grid|1|1|ew 45 apANS($sN,Ind)
      }

      set gStor [list BAND|0 POINT|1]
      set Oc    [list CLOSE|0 OPEN|1]
      set Fill  [list NO|0 YES|1]

      set R 0
      GUIblankRow $Wb $R 2.0

      incr R
      GUILabel $Wb.l$R "Time Based" w grid|$R|0|w 8 0 "" $LFonT
      GUIbuttonToggle $Wb.tB $apANS($sN,tM) grid|$R|1|ew $Fill  \
                       "GUIoptsToggle $Wb.tB apANS($sN,tM) PRI" 0,0.5
      incr R
      GUILabel $Wb.l$R "Grid" w grid|$R|0|w 8 0 "" $LFonT
      GUIbuttonToggle $Wb.gd $apANS($sN,gData) grid|$R|1|ew $YN  \
                       "GUIoptsToggle $Wb.gd apANS($sN,gData) PRI" 0,0.5
      incr R
      GUILabel $Wb.l$R "Grid Base" w grid|$R|0|w 8 0 "" $LFonT
      GUIboxEntry $Wb.gb grid|$R|1|w 10 apANS($sN,gdT)

      incr R
      GUILabel $Wb.l$R "Storage" w grid|$R|0|w 8 0 "" $LFonT
      GUIbuttonToggle $Wb.grd $apANS($sN,gStor) grid|$R|1|ew $gStor  \
                       "GUIoptsToggle $Wb.grd apANS($sN,gStor) PRI" 0,0.5
      incr R
      GUILabel $Wb.l$R "Fill" w grid|$R|0|w 8 0 "" $LFonT
      GUIbuttonToggle $Wb.fill $apANS($sN,gFill) grid|$R|1|ew $Fill  \
                       "GUIoptsToggle $Wb.fill apANS($sN,gFill) PRI" 0,0.5
      incr R
      GUILabel $Wb.l$R "Bad Data" w grid|$R|0|w 8 0 "" $LFonT
      GUIboxEntry $Wb.bad grid|$R|1|w 10 apANS($sN,gBad)

      incr R
      GUIblankRow $Wb $R 2.0

      switch -exact -- $apANS($sN,Src) {
         ASCII {
	    set fC [list MOM-UDF|0 GENERIC|1]

	    APallInits ASCII $sN

            set R 0
            GUILabel $Wf.l$R "Extra Variables" c grid|$R|0|ew||2 0 0 "" $LFonT

            incr R
            GUIblankRow $Wf $R 1.0

            incr R
            GUILabel $Wf.l$R "Time" c grid|$R|0|w 0 0 "" $LFonT
            GUIboxEntry $Wf.tm grid|$R|1|w 13 apANS($sN,tmV)

	    set R 0
	    GUIblankRow $Wc $R 2.0

            incr R
	    GUILabel $Wc.l$R "ASCII FILE NAME" w grid|$R|0|w 0 0 "" $LFonT
            GUIboxEntry $Wc.fname grid|$R|1 40 apANS($sN,aName)
            incr R
	    GUILabel $Wc.l$R "FILE TYPE" w grid|$R|0|w 0 0 "" $LFonT
            GUIbuttonMenu $Wc.fmt "" grid|$R|1|w $fC  \
                   "GUIoptsProcess $Wc.fmt apANS($sN,aFmt) PRI " 0,0.5
            incr R
	    GUILabel $Wc.l$R "MEASUREMENTS" w grid|$R|0|w 0 0 "" $LFonT
            GUIboxEntry $Wc.avar grid|$R|1 40 apANS($sN,aVar)

            incr R
	    GUILabel $Wc.l$R "MF Data" w grid|$R|0|w 0 0 "" $LFonT
            GUIboxEntry $Wc.mfd grid|$R|1 40 apANS($sN,MagF)

            incr R
	    GUIblankRow $Wc $R 2.0

            incr R
	    GUILabel $Wc.l$R "GENERIC FILE INFORMATION" w grid|$R|0|w||2 \
	                               0 0 "" $BFonT

            incr R
	    GUIblankRow $Wc $R 2.0

            incr R
	    GUILabel $Wc.l$R "FILE FORMAT" w grid|$R|0|w 0 0 "" $LFonT
            GUIboxEntry $Wc.ffmt grid|$R|1 40 apANS($sN,lFmT)

            incr R
	    GUILabel $Wc.l$R "FILE VARIABLES" w grid|$R|0|w 0 0 "" $LFonT
            GUIboxEntry $Wc.fvar grid|$R|1 40 apANS($sN,fileVar)

            incr R
	    GUILabel $Wc.l$R "DATA STARTS AFTER" w grid|$R|0|w 0 0 "" $LFonT
            GUIboxEntry $Wc.da grid|$R|1 40 apANS($sN,DataAfter)

            incr R
	    GUILabel $Wc.l$R "COMMENT LINE" w grid|$R|0|w 0 0 "" $LFonT
            GUIboxEntry $Wc.dc grid|$R|1 10 apANS($sN,Comment)

            incr R
	    GUILabel $Wc.l$R "PROVIDE END TIME" w grid|$R|0|w 0 0 "" $LFonT
	    GUIbuttonToggle $Wc.et $apANS($sN,eTime) grid|$R|1|w $YN  \
	                   "GUIoptsToggle $Wc.et apANS($sN,eTime) PRI" 0,0.5
	 }
         UDF { 
            set R 0
            GUILabel $Wf.l$R "Extra Variables" c grid|$R|0|ew||2 0 0 "" $LFonT

            incr R
            GUIblankRow $Wf $R 1.0

            incr R
            GUILabel $Wf.l$R "Time" c grid|$R|0|w 0 0 "" $LFonT
            GUIboxEntry $Wf.tm grid|$R|1|w 13 apANS($sN,tmV)
            incr R
            GUILabel $Wf.l$R "Phase" c grid|$R|0|w 0 0 "" $LFonT
            GUIboxEntry $Wf.ph grid|$R|1|w 13 apANS($sN,phV)
            incr R
            GUILabel $Wf.l$R "Elevation" c grid|$R|0|w 0 0 "" $LFonT
            GUIboxEntry $Wf.th grid|$R|1|w 13 apANS($sN,thV)
            incr R
            GUILabel $Wf.l$R "Spin Period" c grid|$R|0|w 0 0 "" $LFonT
            GUIboxEntry $Wf.sp grid|$R|1|w 13 apANS($sN,spV)

	    set uOps(TwoArray) YES 
	    set uOps(WithAdd) YES 
	    GUudfSrc $Wc "$LaB" NO UD$sN apANS uOps 
	 }
      }

      APfillGUI VARIABLE $sN
      if [string match ASCII $apANS($sN,Src)] {
         APfillGUI ASCII $sN
      } else { GUfillUdfSrc $Wc apANS UD$sN }

   } else { GUIwindowCtrl .apSRC$sN }
}
