package provide UDFAnalysis 1.0

proc APsolveWT { fD } {
   global apANS env RtoD

   APkeepTabs "STEP $fD : WAVE-TELESCOPE"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# DATA cadence and FFT time span
 
   set dT $apANS(CellSz)
   APmakeGrid gI

   set nE $gI(4)
   set eN 1
   while { $eN <= $nE } { set eN [expr $eN << 1] }
   if { $eN > $nE } { set eN [expr $eN >> 1] }
   set tT [expr $eN * $dT]

# THIS is the number of instances to run the function. Remember each
#   entry occupes two lines

   set nFd [expr [$W index end] / 3]

# NO instances then return

   if { $nFd == 0 } { return }

# LOOP over the instances

   set Ln 0
   for { set I 0 } { $I < $nFd } { incr I } {

# GET the first three lines in the entry and break them appart
   
      set LiNe [$W get $Ln]
      incr Ln
      scan $LiNe "%s %s %s %s %s %s %s" _locI _kO _phO _mnK _mnF _mnP _mnT

      set LiNe [$W get $Ln]
      incr Ln
      scan $LiNe "%s %s %s %s %s %s %s" _fftI _fO _thO _mxK _mxF _mxP _mxT

      set LiNe [$W get $Ln]
      incr Ln
      scan $LiNe "%s %s %s %s %s" _pwrO _stK _stF _stP _stT

# GET the output arrays. There is only one K, Freq, Phi, and Theta array
#    but mulptiple sets of power arrays
 
      set kName  [lindex [lindex [APgetVNames $_kO] 0] 0]
      set fName  [lindex [lindex [APgetVNames $_fO] 0] 0]
      set pName  [lindex [lindex [APgetVNames $_phO] 0] 0]
      set tName  [lindex [lindex [APgetVNames $_thO] 0] 0]
      set wNames [lindex [APgetVNames $_pwrO] 0]

# COMPUTE the step sizes.

      if { $_stK > 1 } {
         set szK [expr ($_mxK - $_mnK) / (double($_stK) - 1.0)]
      } else { set szK 0.0  }
      if { $_stF > 1 } {
         set szF [expr ($_mxF - $_mnF) / (double($_stF) - 1.0)]
      } else { set szF 0.0  }
      if { $_stP > 1 } {
         set szP [expr ($_mxP - $_mnP) / (double($_stP) - 1.0)]
      } else { set szP 0.0  }
      if { $_stT > 1 } {
         set szT [expr ($_mxT - $_mnT) / (double($_stT) - 1.0)]
      } else { set szT 0.0  }

# PREFILL in the K, Freq, Phi and Theta arrays.
 
      global [set kName ] ; upvar 0 [set kName] _Kout
      for {set K 0 } { $K < $_stK } { incr K } {
	 set _Kout($K) [expr $_mnK + $K * $szK]
      }
      set _Kout(Dim) [list $K 1]

      global [set fName ] ; upvar 0 [set fName] _Fout
      for {set K 0 } { $K < $_stF } { incr K } {
         set _Fout($K) [expr $_mnF + $K * $szF]
      }
      set _Fout(Dim) [list $K 1]

      global [set pName ] ; upvar 0 [set pName] _Pout
      for {set K 0 } { $K < $_stP } { incr K } {
	 set _Pout($K) [expr $_mnP + $K * $szP]
      }
      set _Pout(Dim) [list $K 1]
      set nPh $K

      global [set tName ] ; upvar 0 [set tName] _Tout
      for {set K 0 } { $K < $_stT } { incr K } {
	 set _Tout($K) [expr $_mnT + $K * $szT]
      }
      set _Tout(Dim) [list $K 1]
      set nTh $K

# THE following generic variables will be set up below.
#   nLc : number of location components
#   nL  : number of locations
#   nF  : total number of ffts
#   nM  : total number of measurements
#   nMc : number of components per measurement
#   nC  : order of the cross spectral density matrix
#   nCs : number of elements in the cross spectral density matrix
#   nD  : number of elements in any of the input arrays

# FIND out how many locations there are.
 
      set lNames [lindex [APgetVNames $_locI] 0]
      set nLc [llength $lNames]
      set nL  [expr $nLc / 3]

# FIND out how many ffts out there
 
      set vNames [lindex [APgetVNames $_fftI] 0]
      set nF  [llength $vNames]
      set nM  [expr $nF / 2 ]
      set nMc  [expr $nM / $nL]
      
# Order of the cross spectral density matrix, number of elements in it, and
#    the number of elements in the propagation matrix

      set nC  $nLc
      set nCs [expr $nC * $nC]
      set nT  [expr $nL * 9]

# SET up pointers to the FFT arrays 
 
      for {set J 0 ; set K 0 } { $J < $nF } { incr J ; incr K } {
         set vR [lindex $vNames $J ]
         global [set vR ] ; upvar 0 [set vR] rFfT$K
	 incr J
         set vR [lindex $vNames $J ]
         global [set vR ] ; upvar 0 [set vR] iFfT$K
      }

# SET up avg s/c positions
 
      for {set J 0 } { $J < $nLc } { incr J } {
         set vR [lindex $lNames $J ]
         global [set vR ] ; upvar 0 [set vR] _TmP
         set _Loc($J) $_TmP(0)
      }
 
# IF the FFT data has been gridded this is the grid Information
 
  if [info exist rFfT0(gInE)] { APxferGInfo  rFfT0 gIF DATA REVERSE }

# LOOP over K
 
      set cTrA 0
      for {set Ia 0 } { $Ia < $_stK } { incr Ia } {
         set Km $_Kout($Ia)

# LOOP over Freq

         set Fc 0
         for {set Ib 0 } { $Ib < $_stF } { incr Ib } {
            set F $_Fout($Ib)

# GET the offset into the FFT array for the current frequency
 
            if ![info exists gIF] {
               set dF $rFfT0(dF)
               set oF [expr round($F / $dF)]
            } else { 
	       TUgridInfo 0 gIF rVgI $F 0.0 
	       set oF $rVgI(0)
	    }

# BUILD the real and imaginary power matrices for this frequency
 
            for {set J  0 } { $J < $nLc } { incr J } {
	       set tVar rFfT$J 
	       upvar 0 $tVar _T_ ; set rM($J) $_T_($oF)
	       set tVar iFfT$J
	       upvar 0 $tVar _T_ ; set iM($J) $_T_($oF)
            }

# COMPUTE the Hermetian conjugate of the to S matrices. The Hermetian
#   conjugate of the imaginary matrix is the negative of its transpose
	 
            TUcmatrixMath rM iM HERMITIAN rM iM rMt iMt $nC 1 $nC 1

# FORM the 12x12 cross spectral matrix.  This is formed by
#   multiplying the transpose of the real and imaginary matrices by their 
#   column versions and then subtracting the imaginary from the real. The 
#   subtraction takes into account that i*i = -1.

            TUcmatrixMath rM iM * rMt iMt rS iS $nC 1 1 $nC
            TUarrayMath rS / $tT rS $nCs
            TUarrayMath iS / $tT iS $nCs

# NOW we have the real and complex cross spectral matrices set up in rS and iS
#   and we need to invert the full complex matrix
 
            set rV [TUmatrixCInv $nC rS iS rsI isI 1.0e-6 .001]

# SET up the output variables
 
            set vR [lindex $wNames $cTrA ]
            global [set vR ] ; upvar 0 [set vR] _POuT
	    incr cTrA

# THESE two loops build the phi, theta mapping for an individual k which
#   is given as kM. The angular stepping sizes are given in dPhi and dTheta
 
        
            set cTrB 0
            for {set Ic 0 } { $Ic < $_stP } { incr Ic } {
               set Phi [expr $_Pout($Ic) / $RtoD]
               set sP [expr sin($Phi)] ; set cP [expr cos($Phi)]
               for {set Id 0 } { $Id < $_stT } { incr Id } {
                  set Theta [expr $_Tout($Id) / $RtoD]

# DETERMINE kx, ky, kz from spherical coordinates
 
                  set sT [expr sin($Theta)] ; set cT [expr cos($Theta)]
                  set _wv(0) [expr $Km * $cP * $sT]
                  set _wv(1) [expr $Km * $sP * $sT]
                  set _wv(2) [expr $Km * $cT]

# INITIALIZE the real and imaginary parts of the propagation matrix.  This
#   consists of nL 3x3 matrices.  The total number of elements is then 9*nL
 
                  for { set L 0 } { $L < $nT } { incr L } { 
                     set rH($L) 0.0 ; set iH($L) 0.0 
                  }

# FILL in the diagonals of the 3x3 matrices

		  set cTrC 0
                  for { set J 0 } { $J < $nL } { incr J } {
                     set N [expr $J * 9]
	             for { set M 0 } { $M < 3 } { incr M ; incr cTrC} {
		        set kdR [expr $_wv($M) * $_Loc($cTrC)]
		        set coS [expr cos($kdR)]
		        set siN [expr sin($kdR)]
		        set rH($N) $coS
		        set iH($N) $siN
		        incr N 4
		     }
		  }

# COMPUTE the transpose of each of the propagation matrices and negate the 
#  imaginary transpose to give its Hermitian conjugate.
 
                  TUcmatrixMath rH iH HERMITIAN rH iH rHt iHt $nC 3 $nC 3
 
# HERE begins the formation of [Ht * cS * H]
# FIRST form the real and imaginary matrices which are produced by [sI * H]
 
                  TUcmatrixMath rsI isI * rH iH rSH iSH $nC $nC $nC 3
 
# NOW complete the multiplication
 
                  TUcmatrixMath rHt iHt * rSH iSH rHSH iHSH 3 $nC $nC 3

# INVERT HSH
		  TUmatrixCInv 3 rHSH iHSH rHSHi iHSHi 1.0e-6 .001

# TRACE
		  set rTr 0.0
		  for { set L 0 } { $L < 9 } { incr L 4 } {
		     set rTr [expr $rTr + $rHSHi($L)]
		  }

                  set _POuT($cTrB) $rTr
                  incr cTrB
               }
            }
	    set _POuT(Dim) [list $nPh $nTh]
         }
      }
   }
}
