package provide UDFAnalysis 1.0

proc APsolveStat { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : STATISTICS"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s" _vI _vO _lT _gT

# GET the input variable list

      set rV [APgetVNames $_vI]
      set iNames [lindex $rV 0]
      set nI [llength $iNames]

# GET the output variable list

      set rV [APgetVNames $_vO]
      set oNames [lindex $rV 0]
      set nO [llength $oNames]

      for { set J 0 } { $J <  $nI } { incr J } {

         set vR [lindex $iNames $J]
         global [set vR]
         upvar 0 [set vR] _In

	 APtimeSpan _In BeG EnD

         set vR [lindex $oNames $J]
         global [set vR]
         upvar 0 [set vR] _Out
         set _Out(Dim) [list 5 1]
         set _Out(aType) STAT

# INITIALIZE STAT data to junk

         for { set K 0 } { $K <  5} { incr K } { set _Out($K) -1.0 }
         set _Out(nE) 0.0 

# WORK only with data within the specified range

         set nE 0
         for { set K $BeG } { $K <  $EnD } { incr K } {
            if { ($_In($K) < $_gT) && ($_In($K) > $_lT) } { 
	       set _TmP($nE) $_In($K)
	       incr nE
            }
         }

# TRIVIAL COMP

         if { $nE < 2 } { 
            if { $nE == 1 } {
	       set _Out(0) $_In(0)
	       set _Out(1) 0.0
	    }
            continue
         }
      
# MEAN VALUE

         set mV [TUarrayMath _TmP AVG _TmP _TmP $nE]

# VARIANCE and AVERAGE DEVIATION

         set Var [TUarrayMath _TmP VAR $mV _TmP $nE]

         TUarrayMath _TmP - $mV _T $nE
         for { set K 0 } { $K <  $nE } { incr K } {
            if { $_T($K) < 0.0 } { 
	       set _S($K) [expr -$_T($K)] 
	    } else { set _S($K) $_T($K) } 
         }
         set aDev [TUarrayMath _S SUM _S _S $nE]
         set aDev [expr $aDev / double($nE)]
     
# STANDARD DEVIATION

         set sD [expr sqrt($Var)]

# SKEW and KURTOSIS

	 if { $sD >  0.0 } { 
            TUarrayMath _T / $sD _T $nE
            TUarrayMath _T * _T _T2 $nE
            TUarrayMath _T2 * _T _Ts $nE
            TUarrayMath _T2 * _T2 _Tk $nE
            set sK [TUarrayMath _Ts SUM _Ts _Ts $nE]
            set kU [TUarrayMath _Tk SUM _Tk _Tk $nE]
            set sK [expr $sK / double($nE)]
            set kU [expr $kU / double($nE) - 3.0]
         } else { set sK 0.0; set kU 0.0 }

         set _Out(nE) $nE;
         set _Out(0) $mV;
         set _Out(1) $Var;
         set _Out(2) $sD;
         set _Out(3) $aDev;
         set _Out(4) $sK;
         set _Out(5) $kU;
      }
   }
}
