package provide UDFAnalysis 1.0

proc APsolveSD { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : SPATIAL-DERIVATIVE"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# WE are always solving a fit to a polynomial function.  This is the
#   procedure which will return the basis functions 

   set _fN TUpoly3DFunc

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# SOME general presets

   set cS [expr double($apANS(CellSz))]
   set Bad $apANS(BaD)

# LOOP over the instances to see how to group definitions

   set Starts ""
   for { set I 0 } { $I < $nF } { incr I } {
      set LiNe [$W get $I]
      scan $LiNe "%s" _vP
      if ![string match "---"  $_vP] { lappend Starts $I }
   }

# LOOP over the definition groups

   set nG [expr [llength $Starts] - 1 ]
   for { set G 0 } { $G <= $nG } { incr G } {

      if { $G != $nG } {
         set eG [lindex $Starts [expr $G + 1]]
      } else { set eG $nF }
      set bG [lindex $Starts $G]

# DO all the position computations associated with this group up-front. Get
#   the info from the first line in the definition

      set LiNe [$W get $bG]
      scan $LiNe "%s %s %s %s %s %s %s %s" _vP _vD _iT _vI _ex _fO _vSD _vR
      set _ex [expr $_ex - 1]

      set vNames [lindex [APgetVNames $_vP] 0]
      set npV [llength $vNames]

# COMPUTE the number of positions defining the volume.  There needs to be
#   at least 4.

      set vS [expr $npV / 3]
      if { $vS < 4 } { return }

# SET up the position variable arrays.

      APsdVar X $vS $vNames _X
      APsdVar Y $vS $vNames _Y
      APsdVar Z $vS $vNames _Z
      set nE [lindex $_X(Dim) 0]

# THIS is the real end of data.  It shortens if the volumes are being extended

      set tnV [expr $nE - $_ex]

# THIS is the total number of points which make up a volume

      set tvS [expr $vS * (1 + $_ex)]

# IF there is a delay OR if the volume is being extended then the first input
#    variable must be a vector which is the set of plasma bulk velocities
#    at each  point defining the volume.  Process those now as vx0, vy0 etc.

      if { ![string match "---"  $_vD] || ( $_ex > 0 ) } {
         if ![string match VECTOR $_iT] { return }
         set vNames [lindex [APgetVNames $_vI] 0]
         if { $npV != [llength $vNames] } { return }

         APsdVar X $vS $vNames _XV
         APsdVar Y $vS $vNames _YV
         APsdVar Z $vS $vNames _ZV
         set nE [lindex $_XV(Dim) 0]
      }

# SEE if there is a delay array.  If so then some of the positions will 
#   need to be shifted by the plasma bulk velocity

      if ![string match "---"  $_vD] { 

# READ the delay array.  There is only one.

         set vR [lindex [lindex [APgetVNames $_vD] 0 ] 0 ]
         global [set vR ]
         upvar 0 [set vR] _DlY

# APPLY the delays

         for { set J 0 } { $J < $nE } { incr J } { 
            set P [expr $J % $vS]
            set _X($J) [expr $_X($J) + $_XV($J) * _DlY($P)]
            set _Y($J) [expr $_Y($J) + $_YV($J) * _DlY($P)]
            set _Z($J) [expr $_Z($J) + $_ZV($J) * _DlY($P)]
         }
      }

# COMPUTE the volume center.  Need to add any of the extended volume to this. 

      for { set J 0 } { $J < $tnV } { incr J } { 
         set _Xc($J) 0.0 ; set _Yc($J) 0.0 ; set _Zc($J) 0.0
         set K [expr $J * $vS]
         for { set L 0 } { $L < $vS } { incr K ; incr L } { 
            set _Xc($J) [expr $_Xc($J) + $_X($K)]
            set _Yc($J) [expr $_Yc($J) + $_Y($K)]
            set _Zc($J) [expr $_Zc($J) + $_Z($K)]
         }

         for { set L 1 } { $L <= $_ex } { incr L } { 
            set T [expr $L * $cS]
            set End [expr $K + $vS]
            for {  } { $K < $End } { incr K } { 
               set _Xc($J) [expr $_Xc($J) + $_X($K) + $_XV($K) * $T]
	       set _Yc($J) [expr $_Yc($J) + $_Y($K) + $_YV($K) * $T]
	       set _Zc($J) [expr $_Zc($J) + $_Z($K) + $_ZV($K) * $T]
            }
         }

         set _Xc($J) [expr $_Xc($J) / double($tvS)]
         set _Yc($J) [expr $_Yc($J) / double($tvS)]
         set _Zc($J) [expr $_Zc($J) / double($tvS)]
      }

# LOOP over the definitions in each group

      for { set I $bG } { $I < $eG } { incr I } {

# GET the information for this definition
   
         set LiNe [$W get $I]
         scan $LiNe "%s %s %s %s %s %s %s %s" _vP _vD _iT _vI _ex _fO _vSD _vR
         set _ex [expr $_ex - 1]

# Save the fit order for use in the Least-Sq algorithm

         set fOps(OR) $_fO

# GET input data variables and stick them in super varaibles. 

         set vNames [lindex [APgetVNames $_vI] 0]
         if [string match VECTOR $_iT] { 
            APsdVar X $vS $vNames _XI
            APsdVar Y $vS $vNames _YI
            APsdVar Z $vS $vNames _ZI
         } else { APsdVar S $vS $vNames _XI }

# SET up the NoData array.  We are assuming that the data is all related.
#   So we only set up a single bad data array. 

         for { set J 0 } { $J < $tnV } { incr J } { 
	    set NoData($J) 0
	    set K [expr $J * $vS]
	    set End [expr $K + $tvS]
            for { } { $K < $End } { incr K } { 
               if { $_XI($K) < $apANS(BaDL) } { set NoData($J) 1 }
            }
         }

# PROCESS the input data. Both vector and scalar data can return one
#    scalar and one vector output.
# FOR scalars we compute the Gradient and Laplacian, however the Laplacian
#   is only computed if the fit order is > 1.  If its 1 the data only has
#   a linear dependence on position so the Laplacian is everywhere 0. If
#   there are at least 3 return varaibles then return gradient, if 4 then
#   gradient and Laplacian, and if 1 Laplacian.
# FOR vectors its the Cross and Dot products.

# SET up the returns and initialize all of the return arrays. sV are vector
#    returns, sS are scalar returns, and sR are raw returns

         set sV 0 ; set sS 0 ; set sR 0

         set rL ""
	 set oVc 0
         if ![string match "---"  $_vSD] {
            set tNames [lindex [APgetVNames $_vSD] 0]
            set nN [llength $tNames]
	    if { $nN >= 3 } { 
	       set sV 1 
               if [string match SCALAR $_iT] { 
		  lappend rL GRADIENT
               } else { lappend rL CROSS }
	       set vR [lindex $tNames $oVc] ; global [set vR]
	       incr oVc
	       upvar 0 [set vR] _oX ; set _oX(Dim) [list $nE 1]
	       APxferGInfo _X _oX
	       set vR [lindex $tNames $oVc] ; global [set vR]
	       incr oVc
	       upvar 0 [set vR] _oY ; set _oY(Dim) [list $nE 1]
	       APxferGInfo _Y _oY
	       set vR [lindex $tNames $oVc] ; global [set vR]
	       incr oVc
	       upvar 0 [set vR] _oZ ; set _oZ(Dim) [list $nE 1]
	       APxferGInfo _Z _oZ

              for { set J 0 } { $J < $nE } { incr J } {
                 set _oX($J) $Bad ; set _oY($J) $Bad ; set _oZ($J) $Bad 
               }
            }
	    if { ($nN > 3) || !$sV } { 
               if [string match SCALAR $_iT] {
	          if { $_fO > 1 } { set sS 1 ; lappend rL LAPLACIAN }
               } else { set sS 1 ; lappend rL DOT }
            }

	    if $sS {
	       set vR [lindex $tNames $oVc] ; global [set vR]
	       upvar 0 [set vR] _oS ; set _oS(Dim) [list $nE 1]
	       APxferGInfo _X _oS
               for { set J 0 } { $J < $nE } { incr J } { set _oS($J) $Bad } 
            } 
         }

         if ![string match "---"  $_vR] { 
	    set sR 1 
            set tNames [lindex [APgetVNames $_vR] 0]
	    set vR [lindex $tNames 0] ; global [set vR]
	    upvar 0 [set vR] _rX ; set _rX(Dim) [list $nE 1]
	    APxferGInfo _X _rX
            for { set J 0 } { $J < $nE } { incr J } { set _rX($J) $Bad } 
            if [string match VECTOR $_iT] { 
	       set vR [lindex $tNames 1] ; global [set vR]
	       upvar 0 [set vR] _rY ; set _rY(Dim) [list $nE 1]
	       APxferGInfo _X _rY
	       set vR [lindex $tNames 2] ; global [set vR]
	       upvar 0 [set vR] _rZ ; set _rZ(Dim) [list $nE 1]
	       APxferGInfo _X _rZ
               for { set J 0 } { $J < $nE } { incr J } { 
	           set _rY($J) $Bad ; set _rZ($J) $Bad 
	       } 
	    }
         } 

	 if {!$sV && !$sR && !$sS } { continue } 
	  
# FIT the data. Scalar and vector data are processed slightly differently

         if [string match SCALAR $_iT] {
            for { set J 0 } { $J < $tnV } { incr J } {
               if $NoData($J) { continue }

	       set K [expr $J * $vS]
               for { set L 0 } { $L < $vS } { incr K ; incr L } { 
	          set _tX($L) $_X($K)
	          set _tY($L) $_Y($K)
	          set _tZ($L) $_Z($K)
	          set _tD($L) $_XI($K)
               }

 
               for { set N 1 } { $N <= $_ex } { incr N } { 
                  set T [expr $N * $cS]
	          set End [expr $L + $vS]
                  for { } { $L < $End } { incr K ; incr L } { 
                     set _tX($L) [expr $_X($K) + $_XV($K) * $T]
                     set _tY($L) [expr $_Y($K) + $_YV($K) * $T]
                     set _tZ($L) [expr $_Z($K) + $_ZV($K) * $T]
	             set _tD($L) $_XI($K)
                  }
               }

               if [info exists _iA] { unset _iA }
               if [info exists _cX] { unset _cX }
               if [info exists fOps(NC)] { unset fOps(NC) }
	       TUdataLSq3D _tX _tY _tZ _tD $tvS 0 _cX _iA fOps cV $_fN 
	       APpolyDeriv _cX _cX _cX $_fO $rL SCALAR \
		                                $_Xc($J) $_Yc($J) $_Zc($J) rV

	       if $sS { set _oS($J) $rV(0) }
	       if $sV  {
                  set _oX($J) $rV(1) 
	          set _oY($J) $rV(2) 
	          set _oZ($J) $rV(3)
               }

	       if $sR {
	          TUpoly3DFunc $_Xc($J) $_Yc($J) $_Zc($J) _bF $fOps(NC) _fO
		  set _rX($J) $_cX(0) 
		  for { set K 1 } { $K < $fOps(NC) } { incr K } {
		     set _rX($J) [expr $_rX($J) + $_bF($K) * $_cX($K)] 
		  }
               }
            } 
         } else {
            for { set J 0 } { $J < $tnV } { incr J } {
               if $NoData($J) { continue }
               
	       set K [expr $J * $vS]
               for { set L 0 } { $L < $vS } { incr K ; incr L } { 
	          set _tX($L) $_X($K)
	          set _tY($L) $_Y($K)
	          set _tZ($L) $_Z($K)
	          set _tDx($L) $_XI($K)
	          set _tDy($L) $_YI($K)
	          set _tDz($L) $_ZI($K)
               }
 
               for { set N 1 } { $N <= $_ex } { incr N } { 
                  set T [expr $N * $cS]
	          set End [expr $L + $vS]
                  for { } { $L < $End } { incr K ; incr L } { 
                     set _tX($L) [expr $_X($K) + $_XV($K) * $T]
                     set _tY($L) [expr $_Y($K) + $_YV($K) * $T]
                     set _tZ($L) [expr $_Z($K) + $_ZV($K) * $T]
	             set _tDx($L) $_XI($K)
	             set _tDy($L) $_YI($K)
	             set _tDz($L) $_ZI($K)
                  }
               }
               if [info exists _iAx] { unset _iAx }
               if [info exists _cX] { unset _cX }
               if [info exists _iAy] { unset _iAy }
               if [info exists _cY] { unset _cY }
               if [info exists _iAz] { unset _iAz }
               if [info exists _cZ] { unset _cZ }
               if [info exists fOps(NC)] { unset fOps(NC) }

	       TUdataLSq3D _tX _tY _tZ _tDx $tvS 0 _cX _iAx fOps cV $_fN 
	       TUdataLSq3D _tX _tY _tZ _tDy $tvS 0 _cY _iAy fOps cV $_fN 
	       TUdataLSq3D _tX _tY _tZ _tDz $tvS 0 _cZ _iAz fOps cV $_fN 

	       APpolyDeriv _cX _cY _cZ $_fO $rL VECTOR \
	                                     $_Xc($J) $_Yc($J) $_Zc($J) rV

	       if $sS { set _oS($J) $rV(0) }
	       if $sV  {
                  set _oX($J) $rV(1) 
	          set _oY($J) $rV(2) 
	          set _oZ($J) $rV(3)
               }

	       if { $sR > 0 } {
	          TUpoly3DFunc $_Xc($J) $_Yc($J) $_Zc($J) _bF $fOps(NC) _fO
		  set _rX($J) $_cX(0) 
		  set _rY($J) $_cY(0) 
		  set _rZ($J) $_cZ(0)
		  for { set K 1 } { $K < $fOps(NC) } { incr K } {
		     set _rX($J) [expr $_rX($J) + $_bF($K) * $_cX($K)] 
		     set _rY($J) [expr $_rY($J) + $_bF($K) * $_cY($K)] 
		     set _rZ($J) [expr $_rZ($J) + $_bF($K) * $_cZ($K)] 
		  }
               }
            }
         }
      }
   }
}
